/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.DefaultResizeHandler;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.FillPolicy;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.psi.xml.XmlTag;
import icons.AndroidDesignerIcons;
import icons.AndroidIcons;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearLayoutHandler
extends ViewGroupHandler {
    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        if (!component.getTagName().equals("LinearLayout")) {
            return super.getTitleAttributes(component);
        }
        return this.isVertical(component) ? "(vertical)" : "(horizontal)";
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        if (!component.getTagName().equals("LinearLayout")) {
            return super.getIcon(component);
        }
        return this.isVertical(component) ? AndroidIcons.Views.VerticalLinearLayout : AndroidIcons.Views.LinearLayout;
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"orientation");
    }

    @Override
    public boolean paintConstraints(@NotNull ScreenView screenView, @NotNull Graphics2D graphics, @NotNull NlComponent component) {
        NlComponent prev = null;
        boolean vertical = this.isVertical(component);
        for (NlComponent child : component.getChildren()) {
            if (prev != null) {
                int middle;
                if (vertical) {
                    middle = Coordinates.getSwingY(screenView, (prev.y + prev.h + child.y) / 2);
                    NlGraphics.drawLine(NlDrawingStyle.GUIDELINE_DASHED, graphics, Coordinates.getSwingX(screenView, component.x), middle, Coordinates.getSwingX(screenView, component.x + component.w), middle);
                } else {
                    middle = Coordinates.getSwingX(screenView, (prev.x + prev.w + child.x) / 2);
                    NlGraphics.drawLine(NlDrawingStyle.GUIDELINE_DASHED, graphics, middle, Coordinates.getSwingY(screenView, component.y), middle, Coordinates.getSwingY(screenView, component.y + component.h));
                }
            }
            prev = child;
        }
        return false;
    }

    protected boolean isVertical(@NotNull NlComponent component) {
        String orientation = component.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
        return "vertical".equals(orientation);
    }

    private static String getCurrentOrientation(@NotNull NlComponent component) {
        String orientation = component.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
        if (orientation == null || orientation.length() == 0) {
            orientation = "horizontal";
        }
        return orientation;
    }

    private void distributeWeights(NlComponent parentNode, NlComponent[] targets) {
        String weightSum = parentNode.getAttribute("http://schemas.android.com/apk/res/android", "weightSum");
        double sum = -1.0;
        if (weightSum != null) {
            try {
                sum = Double.parseDouble(weightSum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int numTargets = targets.length;
        double share = sum <= 0.0 ? 1.0 : sum / (double)numTargets;
        String value = XmlUtils.formatFloatAttribute((double)((float)share));
        String sizeAttribute = this.isVertical(parentNode) ? "layout_height" : "layout_width";
        for (NlComponent target : targets) {
            target.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", value);
            if (!"wrap_content".equals(target.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute))) continue;
            target.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
        }
    }

    private void clearWeights(NlComponent parentNode) {
        String sizeAttribute = this.isVertical(parentNode) ? "layout_height" : "layout_width";
        for (NlComponent target : parentNode.getChildren()) {
            target.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
            String size = target.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute);
            if (size == null || !size.startsWith("0")) continue;
            target.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "wrap_content");
        }
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (layout.w == 0 || layout.h == 0) {
            return null;
        }
        return new LinearDragHandler(editor, layout, components, type);
    }

    @Override
    public void onChildInserted(@NotNull NlComponent layout, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.MOVE_WITHIN) {
            return;
        }
        ViewHandler viewHandler = newChild.getViewHandler();
        if (viewHandler != null) {
            boolean vertical = this.isVertical(layout);
            FillPolicy fill = viewHandler.getFillPolicy();
            String fillParent = "match_parent";
            if (fill.fillHorizontally(vertical)) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fillParent);
            } else if (!vertical && fill == FillPolicy.WIDTH_IN_VERTICAL) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", "1");
            }
            if (fill.fillVertically(vertical)) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fillParent);
            }
        }
        boolean duplicateWeight = true;
        boolean duplicate0dip = true;
        String sameWeight = null;
        String sizeAttribute = this.isVertical(layout) ? "layout_height" : "layout_width";
        for (NlComponent target : layout.getChildren()) {
            String size;
            if (target == newChild) continue;
            String weight = target.getAttribute("http://schemas.android.com/apk/res/android", "layout_weight");
            if (weight == null || weight.length() == 0) {
                duplicateWeight = false;
                break;
            }
            if (sameWeight != null && !sameWeight.equals(weight)) {
                duplicateWeight = false;
            } else {
                sameWeight = weight;
            }
            if ((size = target.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute)) == null || size.startsWith("0")) continue;
            duplicate0dip = false;
            break;
        }
        if (duplicateWeight && sameWeight != null) {
            newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", sameWeight);
            if (duplicate0dip) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
            }
        }
    }

    @Override
    @Nullable
    public ResizeHandler createResizeHandler(@NotNull ViewEditor editor, @NotNull NlComponent component, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        return new LinearResizeHandler(editor, this, component, horizontalEdgeType, verticalEdgeType);
    }

    private static float getWeight(@NotNull NlComponent linearLayoutChild) {
        String weight = linearLayoutChild.getAttribute("http://schemas.android.com/apk/res/android", "layout_weight");
        if (weight != null && weight.length() > 0) {
            try {
                return Float.parseFloat(weight);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    private static float getWeightSum(@NotNull NlComponent linearLayout) {
        String weightSum = linearLayout.getAttribute("http://schemas.android.com/apk/res/android", "weightSum");
        float sum = -1.0f;
        if (weightSum != null) {
            try {
                sum = Float.parseFloat(weightSum);
                return sum;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return LinearLayoutHandler.getSumOfWeights(linearLayout);
    }

    private static float getSumOfWeights(@NotNull NlComponent linearLayout) {
        float sum = 0.0f;
        for (NlComponent child : linearLayout.getChildren()) {
            sum += LinearLayoutHandler.getWeight(child);
        }
        return sum;
    }

    private void clearWeights(@NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren) {
        String sizeAttribute = this.isVertical(component) ? "layout_height" : "layout_width";
        for (NlComponent selected : selectedChildren) {
            selected.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
            String size = selected.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute);
            if (size == null || !size.startsWith("0")) continue;
            selected.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "wrap_content");
        }
    }

    private void distributeWeights(@NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren) {
        String weightSum = component.getAttribute("http://schemas.android.com/apk/res/android", "weightSum");
        double sum = -1.0;
        if (weightSum != null && !weightSum.isEmpty()) {
            try {
                sum = Double.parseDouble(weightSum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int numTargets = selectedChildren.size();
        double share = sum <= 0.0 ? 1.0 : sum / (double)numTargets;
        String value = XmlUtils.formatFloatAttribute((double)((float)share));
        String sizeAttribute = this.isVertical(component) ? "layout_height" : "layout_width";
        for (NlComponent selected : selectedChildren) {
            selected.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", value);
            if (!"wrap_content".equals(selected.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute))) continue;
            selected.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
        }
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions) {
        int rank = 0;
        actions.add(new ToggleOrientationAction().setRank(rank += 20));
        actions.add(new BaselineAction().setRank(rank += 20));
        actions.add(new DistributeWeightsAction().setRank(rank += 20));
        actions.add(new DominateWeightsAction().setRank(rank += 20));
        actions.add(new ClearWeightsAction().setRank(rank += 20));
        actions.add(new ViewActionSeparator().setRank(rank += 20));
        this.addDefaultViewActions(actions, rank);
    }

    @Override
    public void addPopupMenuActions(@NotNull List<ViewAction> actions) {
        this.addToolbarActionsToMenu("LinearLayout", actions);
    }

    private static class BaselineAction
    extends DirectViewAction {
        private BaselineAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            boolean align = !BaselineAction.isBaselineAligned(component);
            component.setAttribute("http://schemas.android.com/apk/res/android", "baselineAligned", align ? null : "false");
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            boolean align = !BaselineAction.isBaselineAligned(component);
            presentation.setIcon(align ? AndroidDesignerIcons.Baseline : AndroidDesignerIcons.NoBaseline);
            presentation.setLabel(align ? "Align with the baseline" : "Do not align with the baseline");
        }

        private static boolean isBaselineAligned(NlComponent component) {
            String value = component.getAttribute("http://schemas.android.com/apk/res/android", "baselineAligned");
            return value == null ? true : Boolean.valueOf(value);
        }
    }

    private class ClearWeightsAction
    extends DirectViewAction {
        public ClearWeightsAction() {
            super(AndroidDesignerIcons.ClearWeights, "Clear All Weights");
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            LinearLayoutHandler.this.clearWeights(component, selectedChildren);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            presentation.setVisible(!selectedChildren.isEmpty());
        }
    }

    private class DominateWeightsAction
    extends DirectViewAction {
        public DominateWeightsAction() {
            super(AndroidDesignerIcons.DominateWeight, "Assign All Weight");
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            LinearLayoutHandler.this.distributeWeights(component, selectedChildren);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            presentation.setVisible(!selectedChildren.isEmpty());
        }
    }

    private class DistributeWeightsAction
    extends DirectViewAction {
        public DistributeWeightsAction() {
            super(AndroidDesignerIcons.DistributeWeights, "Distribute Weights Evenly");
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            presentation.setVisible(selectedChildren.size() > 1);
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            LinearLayoutHandler.this.distributeWeights(component, selectedChildren);
        }
    }

    private class ToggleOrientationAction
    extends DirectViewAction {
        private ToggleOrientationAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            boolean isHorizontal = !LinearLayoutHandler.this.isVertical(component);
            String value = isHorizontal ? "vertical" : null;
            component.setAttribute("http://schemas.android.com/apk/res/android", "orientation", value);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            boolean vertical = LinearLayoutHandler.this.isVertical(component);
            presentation.setLabel("Convert orientation to " + (!vertical ? "vertical" : "horizontal"));
            Icon icon = vertical ? AndroidDesignerIcons.SwitchVerticalLinear : AndroidDesignerIcons.SwitchHorizontalLinear;
            presentation.setIcon(icon);
        }
    }

    private class LinearResizeHandler
    extends DefaultResizeHandler {
        public boolean useWeight;
        private float mNewWeightSum;
        private float mWeight;
        public final Map<NlComponent, Dimension> unweightedSizes;
        public int totalLength;
        public List<NlComponent> mClearWeights;

        public LinearResizeHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @Nullable NlComponent component, @Nullable SegmentType horizontalEdgeType, SegmentType verticalEdgeType) {
            super(editor, handler, component, horizontalEdgeType, verticalEdgeType);
            this.unweightedSizes = editor.measureChildren(this.layout, new RenderTask.AttributeFilter(){

                @Override
                public String getAttribute(@NotNull XmlTag n, @Nullable String namespace, @NotNull String localName) {
                    if ("layout_weight".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                        return "";
                    }
                    return null;
                }
            });
            this.totalLength = 0;
            boolean isVertical = LinearLayoutHandler.this.isVertical(this.layout);
            if (this.unweightedSizes != null) {
                for (Map.Entry<NlComponent, Dimension> entry : this.unweightedSizes.entrySet()) {
                    Dimension preferredSize = entry.getValue();
                    if (isVertical) {
                        this.totalLength += preferredSize.height;
                        continue;
                    }
                    this.totalLength += preferredSize.width;
                }
            }
        }

        void reset() {
            this.mNewWeightSum = -1.0f;
            this.useWeight = false;
            this.mClearWeights = null;
        }

        void setWeight(float weight) {
            this.useWeight = true;
            this.mWeight = weight;
        }

        void setWeightSum(float weightSum) {
            this.mNewWeightSum = weightSum;
        }

        void clearWeight(NlComponent n) {
            if (this.mClearWeights == null) {
                this.mClearWeights = new ArrayList<NlComponent>();
            }
            this.mClearWeights.add(n);
        }

        public void apply() {
            assert (this.useWeight);
            String value = this.mWeight > 0.0f ? XmlUtils.formatFloatAttribute((double)this.mWeight) : null;
            this.component.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", value);
            if (this.mClearWeights != null) {
                for (NlComponent n : this.mClearWeights) {
                    if (!(LinearLayoutHandler.getWeight(n) > 0.0f)) continue;
                    n.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
                }
            }
            if ((double)this.mNewWeightSum > 0.0) {
                this.layout.setAttribute("http://schemas.android.com/apk/res/android", "weightSum", XmlUtils.formatFloatAttribute((double)this.mNewWeightSum));
            }
        }

        protected void updateResizeState(NlComponent component, NlComponent layout, Rectangle oldBounds, Rectangle newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
            Dimension nodeBounds;
            Map<NlComponent, Dimension> sizes;
            Dimension nodePreferredSize;
            float sum;
            this.reset();
            if (oldBounds.equals(newBounds)) {
                return;
            }
            boolean isVertical = LinearLayoutHandler.this.isVertical(layout);
            if (!isVertical && verticalEdge != null) {
                if (this.wrapWidth || this.fillWidth) {
                    this.clearWeight(component);
                    return;
                }
                if (newBounds.width == oldBounds.width) {
                    return;
                }
            }
            if (isVertical && horizontalEdge != null) {
                if (this.wrapHeight || this.fillHeight) {
                    this.clearWeight(component);
                    return;
                }
                if (newBounds.height == oldBounds.height) {
                    return;
                }
            }
            if ((sum = LinearLayoutHandler.getWeightSum(layout)) <= 0.0f) {
                sum = 1.0f;
                this.setWeightSum(sum);
            }
            Dimension dimension = nodePreferredSize = (sizes = this.unweightedSizes) != null ? sizes.get(component) : null;
            if (nodePreferredSize != null && (horizontalEdge != null && newBounds.height < nodePreferredSize.height || verticalEdge != null && newBounds.width < nodePreferredSize.width)) {
                return;
            }
            Rectangle layoutBounds = new Rectangle(layout.x, layout.y, layout.w, layout.h);
            int remaining = (isVertical ? layoutBounds.height : layoutBounds.width) - this.totalLength;
            Dimension dimension2 = nodeBounds = sizes != null ? sizes.get(component) : null;
            if (nodeBounds == null) {
                return;
            }
            if (remaining > 0) {
                int missing = 0;
                if (isVertical) {
                    if (newBounds.height > nodeBounds.height) {
                        missing = newBounds.height - nodeBounds.height;
                    } else if (this.wrapBounds != null && newBounds.height > this.wrapBounds.height) {
                        missing = newBounds.height - this.wrapBounds.height;
                        remaining += nodeBounds.height - this.wrapBounds.height;
                        this.wrapHeight = true;
                    }
                } else if (newBounds.width > nodeBounds.width) {
                    missing = newBounds.width - nodeBounds.width;
                } else if (this.wrapBounds != null && newBounds.width > this.wrapBounds.width) {
                    missing = newBounds.width - this.wrapBounds.width;
                    remaining += nodeBounds.width - this.wrapBounds.width;
                    this.wrapWidth = true;
                }
                if (missing > 0) {
                    float weight = (float)missing * sum / (float)remaining;
                    this.setWeight(weight);
                }
            }
        }

        @Override
        protected void setNewSizeBounds(@NotNull NlComponent component, @NotNull NlComponent layout, @NotNull Rectangle oldBounds, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
            this.updateResizeState(component, layout, oldBounds, newBounds, horizontalEdge, verticalEdge);
            if (this.useWeight) {
                this.apply();
                boolean isVertical = LinearLayoutHandler.this.isVertical(layout);
                if (!isVertical && horizontalEdge != null && (newBounds.height != oldBounds.height || this.wrapHeight || this.fillHeight)) {
                    component.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", this.getHeightAttribute());
                }
                if (isVertical && verticalEdge != null && (newBounds.width != oldBounds.width || this.wrapWidth || this.fillWidth)) {
                    component.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", this.getWidthAttribute());
                }
            } else {
                component.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
                super.setNewSizeBounds(component, layout, oldBounds, newBounds, horizontalEdge, verticalEdge);
            }
        }

        @Override
        protected String getResizeUpdateMessage(@NotNull NlComponent child, @NotNull NlComponent parent, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
            this.updateResizeState(child, parent, newBounds, newBounds, horizontalEdge, verticalEdge);
            if (this.useWeight) {
                String height;
                String width;
                String weight = XmlUtils.formatFloatAttribute((double)this.mWeight);
                String dimension = String.format("weight %1$s", weight);
                if (LinearLayoutHandler.this.isVertical(parent)) {
                    width = this.getWidthAttribute();
                    height = dimension;
                } else {
                    width = dimension;
                    height = this.getHeightAttribute();
                }
                if (horizontalEdge == null) {
                    return width;
                }
                if (verticalEdge == null) {
                    return height;
                }
                return String.format("%s \u00d7 %s", width, height);
            }
            return super.getResizeUpdateMessage(child, parent, newBounds, horizontalEdge, verticalEdge);
        }
    }

    private static class MatchPos {
        private final int myDistance;
        private final int myPosition;

        public MatchPos(int distance, int position) {
            this.myDistance = distance;
            this.myPosition = position;
        }

        private int getDistance() {
            return this.myDistance;
        }

        private int getPosition() {
            return this.myPosition;
        }
    }

    private class LinearDragHandler
    extends DragHandler {
        private final boolean myVertical;
        private final List<MatchPos> myIndices;
        private final int myNumPositions;
        private Integer myCurrX;
        private Integer myCurrY;
        private int mySelfPos;
        private int myInsertPos;
        private Integer myWidth;
        private Integer myHeight;

        public LinearDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, DragType type) {
            super(editor, LinearLayoutHandler.this, layout, components, type);
            this.myInsertPos = -1;
            assert (!components.isEmpty());
            this.myVertical = LinearLayoutHandler.this.isVertical(layout);
            this.myIndices = new ArrayList<MatchPos>();
            int last = this.myVertical ? layout.y + layout.getPadding().top : layout.x + layout.getPadding().left;
            int pos = 0;
            boolean lastDragged = false;
            this.mySelfPos = -1;
            for (NlComponent it : layout.getChildren()) {
                if (it.w > 0 && it.h > 0) {
                    int v;
                    boolean isDragged = components.contains(it);
                    if (isDragged) {
                        v = this.myVertical ? it.y + it.h / 2 : it.x + it.w / 2;
                        this.mySelfPos = pos;
                        this.myIndices.add(new MatchPos(v, pos++));
                    } else if (lastDragged) {
                        ++pos;
                    } else {
                        v = this.myVertical ? it.y : it.x;
                        v = (last + v) / 2;
                        this.myIndices.add(new MatchPos(v, pos++));
                    }
                    last = this.myVertical ? it.y + it.h : it.x + it.w;
                    lastDragged = isDragged;
                    continue;
                }
                ++pos;
            }
            if (!lastDragged) {
                int v = last + 1;
                this.myIndices.add(new MatchPos(v, pos));
            }
            this.myNumPositions = layout.getChildCount() + 1;
        }

        @Override
        @Nullable
        public String update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
            super.update(x, y, modifiers);
            boolean isVertical = this.myVertical;
            int bestDist = Integer.MAX_VALUE;
            int bestIndex = Integer.MIN_VALUE;
            Integer bestPos = null;
            for (MatchPos index : this.myIndices) {
                int i = index.getDistance();
                int pos = index.getPosition();
                int dist = (isVertical ? y : x) - i;
                if (dist < 0) {
                    dist = -dist;
                }
                if (dist >= bestDist) continue;
                bestDist = dist;
                bestIndex = i;
                bestPos = pos;
                if (bestDist > 0) continue;
                break;
            }
            if (bestIndex != Integer.MIN_VALUE) {
                if (isVertical) {
                    this.myCurrX = this.layout.x + this.layout.w / 2;
                    this.myCurrY = bestIndex;
                    this.myWidth = this.layout.w;
                    this.myHeight = null;
                } else {
                    this.myCurrX = bestIndex;
                    this.myCurrY = this.layout.y + this.layout.h / 2;
                    this.myWidth = null;
                    this.myHeight = this.layout.h;
                }
                this.myInsertPos = bestPos;
            }
            return null;
        }

        @Override
        public void paint(@NotNull NlGraphics gc) {
            Insets padding = this.layout.getPadding();
            int layoutX = this.layout.x + padding.left;
            int layoutW = this.layout.w - padding.width();
            int layoutY = this.layout.y + padding.top;
            int layoutH = this.layout.h - padding.height();
            gc.useStyle(NlDrawingStyle.DROP_RECIPIENT);
            gc.drawRect(layoutX, layoutY, layoutW, layoutH);
            gc.useStyle(NlDrawingStyle.DROP_ZONE);
            boolean isVertical = this.myVertical;
            int selfPos = this.mySelfPos;
            for (MatchPos it : this.myIndices) {
                int i = it.getDistance();
                int pos = it.getPosition();
                if (pos == selfPos) continue;
                if (isVertical) {
                    gc.drawLine(layoutX, i, layoutW, i);
                    continue;
                }
                gc.drawLine(i, layoutY, i, layoutH);
            }
            Integer currX = this.myCurrX;
            Integer currY = this.myCurrY;
            if (currX != null && currY != null) {
                gc.useStyle(NlDrawingStyle.DROP_ZONE_ACTIVE);
                int x = currX;
                int y = currY;
                NlComponent be = (NlComponent)this.components.get(0);
                if (this.myInsertPos != selfPos || selfPos == -1) {
                    gc.useStyle(NlDrawingStyle.DROP_PREVIEW);
                    if (this.myWidth != null) {
                        int width = this.myWidth;
                        int fromX = x - width / 2;
                        int toX = x + width / 2;
                        gc.drawLine(fromX, y, toX, y);
                    } else if (this.myHeight != null) {
                        int height = this.myHeight;
                        int fromY = y - height / 2;
                        int toY = y + height / 2;
                        gc.drawLine(x, fromY, x, toY);
                    }
                }
                if (be.w > 0 && be.h > 0) {
                    int offsetY;
                    int offsetX;
                    boolean isLast;
                    boolean bl = isLast = this.myInsertPos == this.myNumPositions - 1;
                    if (isVertical) {
                        offsetX = layoutX - be.x;
                        offsetY = currY - be.y - (isLast ? 0 : be.h / 2);
                    } else {
                        offsetX = currX - be.x - (isLast ? 0 : be.w / 2);
                        offsetY = layoutY - be.y;
                    }
                    gc.useStyle(NlDrawingStyle.DROP_PREVIEW);
                    for (NlComponent element : this.components) {
                        if (element.w > 0 && element.h > 0 && (element.w > layoutW || element.h > layoutH) && this.layout.getChildCount() == 0) {
                            int ph;
                            int py;
                            int pw;
                            int px;
                            if (element.w > layoutW) {
                                px = layoutX;
                                pw = layoutW;
                            } else {
                                px = element.x + offsetX;
                                pw = element.w;
                            }
                            if (element.h > layoutH) {
                                py = layoutY;
                                ph = layoutH;
                            } else {
                                py = element.y + offsetY;
                                ph = element.h;
                            }
                            gc.drawRect(px, py, pw, ph);
                            continue;
                        }
                        this.drawElement(gc, element, offsetX, offsetY);
                    }
                }
            }
        }

        public void drawElement(NlGraphics gc, NlComponent component, int offsetX, int offsetY) {
            if (component.w > 0 && component.h > 0) {
                gc.drawRect(component.x + offsetX, component.y + offsetY, component.w, component.h);
            }
            for (NlComponent inner : component.getChildren()) {
                this.drawElement(gc, inner, offsetX, offsetY);
            }
        }

        @Override
        public int getInsertIndex() {
            return this.myInsertPos;
        }

        @Override
        public void commit(int x, int y, int modifiers) {
        }
    }
}

