/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.resources.ResourceType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IncludeHandler
extends ViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"layout", (Object)"visibility");
    }

    @Override
    @NotNull
    public String getTitle(@NotNull String tagName) {
        return "<include>";
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component) {
        return "<include>";
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        String layout = component.getAttribute(null, "layout");
        return StringUtil.isEmpty((String)layout) ? "" : "- " + layout;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String tagName) {
        return AndroidIcons.Views.Include;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        return AndroidIcons.Views.Include;
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case COMPONENT_CREATION: {
                return "<include/>";
            }
        }
        return "";
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.CREATE) {
            String src = editor.displayResourceInput(EnumSet.of(ResourceType.LAYOUT));
            if (src != null) {
                newChild.setAttribute(null, "layout", src);
                return true;
            }
            return false;
        }
        return true;
    }
}

