/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.uibuilder.api.DefaultResizeHandler;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SegmentType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameLayoutHandler
extends ViewGroupHandler {
    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        return new FrameDragHandler(editor, (ViewGroupHandler)this, layout, (List)components, type){};
    }

    @Override
    @Nullable
    public ResizeHandler createResizeHandler(@NotNull ViewEditor editor, @NotNull NlComponent component, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        return new DefaultResizeHandler(editor, this, component, horizontalEdgeType, verticalEdgeType);
    }

    protected class FrameDragHandler
    extends DragHandler {
        protected FrameDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent layout, @NotNull List<NlComponent> components, DragType type) {
            super(editor, handler, layout, components, type);
        }

        @Override
        public void paint(@NotNull NlGraphics graphics) {
            graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
            graphics.drawRect(this.layout.x, this.layout.y, this.layout.w, this.layout.h);
            for (NlComponent component : this.components) {
                int x = this.layout.x;
                int y = this.layout.y;
                int w = component.w;
                int h = component.h;
                graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
                graphics.drawRect(x, y, w, h);
            }
        }

        @Override
        public void commit(int x, int y, int modifiers) {
        }
    }
}

