/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.editor.NlActionsToolbar;
import com.android.tools.idea.uibuilder.editor.NlPaletteManager;
import com.android.tools.idea.uibuilder.editor.NlPreviewManager;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightFillLayout;
import com.intellij.designer.LightToolWindow;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPreviewForm
implements Disposable,
CaretListener,
DesignerEditorPanelFacade {
    private final NlPreviewManager myManager;
    private final DesignSurface mySurface;
    private final ThreeComponentsSplitter myContentSplitter;
    private final MergingUpdateQueue myRenderingQueue = new MergingUpdateQueue("android.layout.preview.caret", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
    private boolean myUseInteractiveSelector = true;
    private boolean myIgnoreListener;
    private RenderResult myRenderResult;
    private XmlFile myFile;
    private boolean isActive = true;
    private NlActionsToolbar myActionsToolbar;
    private XmlFile myInactiveFile;
    private Pending myPendingFile;
    private TextEditor myEditor;
    private CaretModel myCaretModel;
    private LightToolWindow myToolWindow;

    public NlPreviewForm(NlPreviewManager manager) {
        this.myManager = manager;
        this.mySurface = new DesignSurface(manager.getProject(), this);
        Disposer.register((Disposable)this, (Disposable)this.mySurface);
        this.mySurface.setCentered(true);
        this.mySurface.setScreenMode(DesignSurface.ScreenMode.SCREEN_ONLY, false);
        this.mySurface.addListener(new DesignSurfaceListener(){

            @Override
            public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
                assert (surface == NlPreviewForm.this.mySurface);
                NlComponent component = newSelection.size() == 1 ? newSelection.get(0) : null;
                NlPreviewForm.this.selectComponent(component);
            }

            @Override
            public void screenChanged(@NotNull DesignSurface surface, @Nullable ScreenView screenView) {
            }

            @Override
            public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
            }

            @Override
            public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
                return false;
            }
        });
        this.myRenderingQueue.setRestartTimerOnAdd(true);
        this.myContentSplitter = new ThreeComponentsSplitter();
        JPanel contentPanel = new JPanel((LayoutManager)new LightFillLayout());
        this.myActionsToolbar = new NlActionsToolbar(this.mySurface);
        contentPanel.add(this.myActionsToolbar.getToolbarComponent());
        contentPanel.add(this.mySurface);
        this.myContentSplitter.setDividerWidth(0);
        this.myContentSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.myContentSplitter.setInnerComponent((JComponent)contentPanel);
        Project project = this.myManager.getProject();
        NlPaletteManager paletteManager = NlPaletteManager.get(project);
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        String key = "UI_DESIGNER_EDITOR_MODE." + paletteManager.getVisibilityKeyName(this) + ".SHOW";
        boolean showing = properties.getBoolean(key, true);
        if (showing) {
            properties.setValue(key, Boolean.toString(false));
        }
    }

    private void setEditor(@Nullable TextEditor editor) {
        if (editor != this.myEditor) {
            this.myEditor = editor;
            if (this.myCaretModel != null) {
                this.myCaretModel.removeCaretListener((CaretListener)this);
                this.myCaretModel = null;
            }
            if (editor != null) {
                this.myCaretModel = this.myEditor.getEditor().getCaretModel();
                this.myCaretModel.addCaretListener((CaretListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectComponent(@Nullable NlComponent component) {
        int offset;
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView == null) {
            return;
        }
        if (this.myEditor != null && component != null && component.getTag().isValid() && this.myUseInteractiveSelector && !this.myIgnoreListener && (offset = component.getTag().getTextOffset()) != -1) {
            Editor editor = this.myEditor.getEditor();
            this.myIgnoreListener = true;
            try {
                screenView.getSelectionModel().setSelection(Collections.singletonList(component));
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }
            finally {
                this.myIgnoreListener = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaret() {
        int offset;
        ScreenView screenView;
        if (this.myCaretModel != null && !this.myIgnoreListener && this.myUseInteractiveSelector && (screenView = this.mySurface.getCurrentScreenView()) != null && (offset = this.myCaretModel.getOffset()) != -1) {
            List<NlComponent> views = screenView.getModel().findByOffset(offset);
            if (views == null || views.isEmpty()) {
                views = screenView.getModel().getComponents();
            }
            try {
                this.myIgnoreListener = true;
                SelectionModel selectionModel = screenView.getSelectionModel();
                selectionModel.setSelection(views);
                this.myRenderingQueue.queue(new Update("Preview update"){

                    public void run() {
                        NlPreviewForm.this.mySurface.repaint();
                    }

                    public boolean canEat(Update update) {
                        return true;
                    }
                });
            }
            finally {
                this.myIgnoreListener = false;
            }
        }
    }

    @Nullable
    public XmlFile getFile() {
        return this.myFile;
    }

    @NotNull
    public JPanel getContentPanel() {
        return this.myContentSplitter;
    }

    public void dispose() {
        this.deactivate();
        this.myInactiveFile = null;
        NlPaletteManager.get(this.myManager.getProject()).dispose(this);
    }

    public void setUseInteractiveSelector(boolean useInteractiveSelector) {
        this.myUseInteractiveSelector = useInteractiveSelector;
    }

    public boolean setFile(@Nullable PsiFile file) {
        AndroidFacet facet;
        if (!this.isActive) {
            this.myInactiveFile = (XmlFile)file;
            if (file != null) {
                return false;
            }
        }
        if (this.myPendingFile != null) {
            if (file == this.myPendingFile.file) {
                return false;
            }
            this.myPendingFile.invalidate();
            this.mySurface.setModel(null);
        } else if (file == this.myFile) {
            return false;
        }
        AndroidFacet androidFacet = facet = file instanceof XmlFile ? AndroidFacet.getInstance((PsiElement)file) : null;
        if (facet == null || file.getVirtualFile() == null) {
            this.myPendingFile = null;
            this.myFile = null;
            this.setActiveModel(null);
        } else {
            XmlFile xmlFile = (XmlFile)file;
            NlModel model = NlModel.create(this.mySurface, null, facet, xmlFile);
            this.myPendingFile = new Pending(xmlFile, model);
        }
        return true;
    }

    public void setActiveModel(@Nullable NlModel model) {
        this.myPendingFile = null;
        ScreenView currentScreenView = this.mySurface.getCurrentScreenView();
        if (currentScreenView != null) {
            currentScreenView.getModel().deactivate();
            Disposer.dispose((Disposable)currentScreenView.getModel());
        }
        if (model == null) {
            this.setEditor(null);
            this.myManager.setDesignSurface(null);
        } else {
            this.myFile = model.getFile();
            this.mySurface.setModel(model);
            if (!this.mySurface.isCanvasResizing() && this.mySurface.isZoomFitted()) {
                this.mySurface.zoomToFit();
            }
            this.setEditor(this.myManager.getActiveLayoutXmlEditor());
            model.activate();
            this.myManager.setDesignSurface(this.mySurface);
            this.myActionsToolbar.setModel(model);
            this.attachPalette();
        }
    }

    private void attachPalette() {
        Project project = this.myManager.getProject();
        DumbService.getInstance((Project)project).runWhenSmart(() -> {
            if (NlLayoutType.typeOf(this.myFile).isSupportedByDesigner()) {
                if (this.isActive && this.myFile != null) {
                    NlPaletteManager.get(project).bind(this);
                }
            } else {
                NlPaletteManager.get(project).dispose(this);
            }
        });
    }

    @Nullable
    public RenderResult getRenderResult() {
        return this.myRenderResult;
    }

    public void setRenderResult(@NotNull RenderResult renderResult) {
        this.myRenderResult = renderResult;
    }

    @Nullable
    public Configuration getConfiguration() {
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView != null) {
            return screenView.getModel().getConfiguration();
        }
        return null;
    }

    @NotNull
    public DesignSurface getSurface() {
        return this.mySurface;
    }

    public void caretPositionChanged(CaretEvent e) {
        if (!this.myIgnoreListener) {
            this.updateCaret();
        }
    }

    public void caretAdded(CaretEvent e) {
    }

    public void caretRemoved(CaretEvent e) {
    }

    public void minimizePalette() {
        if (this.myToolWindow != null) {
            try {
                LightToolWindow.class.getDeclaredMethod("minimize", new Class[0]).invoke((Object)this.myToolWindow, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void activate() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        if (this.myFile == null && this.myPendingFile == null) {
            this.setFile((PsiFile)this.myInactiveFile);
        }
        this.myInactiveFile = null;
    }

    public void deactivate() {
        if (!this.isActive) {
            return;
        }
        this.myInactiveFile = this.myFile != null ? this.myFile : (this.myPendingFile != null ? this.myPendingFile.file : null);
        this.setFile(null);
        this.isActive = false;
    }

    public Object getClientProperty(Object key) {
        return this.myContentSplitter.getClientProperty(key);
    }

    public void putClientProperty(Object key, Object value) {
        Project project = this.myManager.getProject();
        NlPaletteManager paletteManager = NlPaletteManager.get(project);
        String paletteKey = paletteManager.getComponentName();
        this.myContentSplitter.putClientProperty(key, value);
        if (key.equals(paletteKey)) {
            this.myToolWindow = (LightToolWindow)value;
        }
    }

    public ThreeComponentsSplitter getContentSplitter() {
        return this.myContentSplitter;
    }

    private class Pending
    implements ModelListener,
    Runnable {
        public final XmlFile file;
        public final NlModel model;
        public boolean valid = true;

        public Pending(XmlFile file, NlModel model) {
            this.file = file;
            this.model = model;
            model.addListener(this);
            model.render();
        }

        @Override
        public void modelChanged(@NotNull NlModel model) {
            model.render();
        }

        @Override
        public void modelRendered(@NotNull NlModel model) {
            model.removeListener(this);
            if (this.valid) {
                this.valid = false;
                ApplicationManager.getApplication().invokeLater((Runnable)this);
            }
        }

        public void invalidate() {
            this.valid = false;
        }

        @Override
        public void run() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            NlPreviewForm.this.setActiveModel(this.model);
        }
    }
}

