/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.uibuilder.editor.NlAbstractWindowManager;
import com.android.tools.idea.uibuilder.palette.NlPalettePanel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPaletteManager
extends NlAbstractWindowManager {
    private NlPalettePanel myPalette;

    public NlPaletteManager(@NotNull Project project, @NotNull FileEditorManager fileEditorManager) {
        super(project, fileEditorManager);
    }

    @NotNull
    public static NlPaletteManager get(@NotNull Project project) {
        return (NlPaletteManager)((Object)project.getComponent(NlPaletteManager.class));
    }

    protected void initToolWindow() {
        this.initToolWindow("Nl-Palette", AllIcons.Toolwindows.ToolWindowPalette);
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        if (designer == null || !NlPaletteManager.getLayoutType(designer).isSupportedByDesigner()) {
            this.myToolWindow.setAvailable(false, null);
            if (this.myPalette != null) {
                this.myPalette.setDesignSurface(null);
            }
        } else {
            if (this.myPalette == null) {
                this.myPalette = new NlPalettePanel(this.myProject, NlPaletteManager.getDesignSurface(designer));
                this.createWindowContent(this.myPalette, this.myPalette.getFocusedComponent(), this.myPalette.getActions());
            }
            this.myPalette.setDesignSurface(NlPaletteManager.getDesignSurface(designer));
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    protected ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.LEFT;
    }

    public String getVisibilityKeyName(@NotNull DesignerEditorPanelFacade designer) {
        return this.getComponentName() + "-" + designer.getClass().getSimpleName();
    }

    public void setDesignSurface(LightToolWindow toolWindow, @Nullable DesignSurface designSurface) {
        NlPalettePanel palette = (NlPalettePanel)toolWindow.getContent();
        palette.setDesignSurface(designSurface);
    }

    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty((Object)this.getComponentName());
        if (toolWindow != null) {
            return toolWindow;
        }
        NlPalettePanel palette = new NlPalettePanel(this.myProject, NlPaletteManager.getDesignSurface(designer));
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String value = propertiesComponent.getValue(this.myEditorModeKey);
        ToolWindowAnchor anchor = value == null ? this.getAnchor() : (value.equals("ToolWindow") ? null : ToolWindowAnchor.fromText((String)value));
        return new LightToolWindow((LightToolWindowContent)palette, "Palette", AllIcons.Toolwindows.ToolWindowPalette, (JComponent)palette, palette.getFocusedComponent(), designer.getContentSplitter(), anchor, (LightToolWindowManager)this, this.myProject, propertiesComponent, this.getVisibilityKeyName(designer), 180, palette.getActions());
    }

    public void disposeComponent() {
        if (this.myPalette != null) {
            this.myPalette.dispose();
        }
    }

    @NotNull
    public String getComponentName() {
        return "NlPaletteManager";
    }
}

