/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;

public class NlEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String DESIGNER_ID = "android-designer2";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        AndroidFacet facet;
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, file);
        AndroidFacet androidFacet = facet = psiFile instanceof XmlFile ? AndroidFacet.getInstance((PsiElement)psiFile) : null;
        if (facet == null) {
            return false;
        }
        if (!Projects.isBuildWithGradle(facet.getModule()) && !Projects.isLegacyIdeaAndroidModule(facet.getModule())) {
            return false;
        }
        return NlLayoutType.supports((XmlFile)psiFile);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        AndroidFacet facet;
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, file);
        AndroidFacet androidFacet = facet = psiFile instanceof XmlFile ? AndroidFacet.getInstance((PsiElement)psiFile) : null;
        assert (facet != null);
        return new NlEditor(facet, file, project);
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        return FileEditorState.INSTANCE;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
    }

    @NotNull
    public String getEditorTypeId() {
        return DESIGNER_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor() ? FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR : FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }
}

