/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class XmlBuilder {
    private final StringBuilder myStringBuilder = new StringBuilder();
    private Construct myLastAppendedConstruct = Construct.NULL;
    private int myIndentationLevel;

    @NotNull
    public XmlBuilder startTag(@NotNull String name) {
        int length;
        if (!this.myLastAppendedConstruct.equals((Object)Construct.END_TAG) && (length = this.myStringBuilder.length()) > 0) {
            this.myStringBuilder.replace(length - 1, length, ">\n");
        }
        if (this.myIndentationLevel != 0) {
            this.myStringBuilder.append('\n');
        }
        this.indent();
        this.myStringBuilder.append('<').append(name).append('\n');
        ++this.myIndentationLevel;
        this.myLastAppendedConstruct = Construct.START_TAG;
        return this;
    }

    @NotNull
    public XmlBuilder androidAttribute(@NotNull String name, boolean value) {
        return this.androidAttribute(name, Boolean.toString(value));
    }

    @NotNull
    public XmlBuilder androidAttribute(@NotNull String name, int value) {
        return this.androidAttribute(name, Integer.toString(value));
    }

    @NotNull
    public XmlBuilder androidAttribute(@NotNull String name, @NotNull String value) {
        return this.attribute("android", name, value);
    }

    @NotNull
    public XmlBuilder attribute(@NotNull String namespacePrefix, @NotNull String name, @NotNull String value) {
        this.indent();
        if (!StringUtil.isEmpty((String)namespacePrefix)) {
            this.myStringBuilder.append(namespacePrefix).append(':');
        }
        this.myStringBuilder.append(name).append("=\"").append(value).append("\"\n");
        this.myLastAppendedConstruct = Construct.ATTRIBUTE;
        return this;
    }

    @NotNull
    public XmlBuilder endTag(@NotNull String name) {
        boolean useEmptyElementTag;
        boolean bl = useEmptyElementTag = !name.endsWith("Layout") && !name.equals("PreferenceCategory");
        if (this.myLastAppendedConstruct.equals((Object)Construct.START_TAG) || this.myLastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) {
            int length = this.myStringBuilder.length();
            if (useEmptyElementTag) {
                this.myStringBuilder.deleteCharAt(length - 1);
            } else {
                this.myStringBuilder.replace(length - 1, length, ">\n\n");
            }
        }
        --this.myIndentationLevel;
        if ((this.myLastAppendedConstruct.equals((Object)Construct.START_TAG) || this.myLastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) && useEmptyElementTag) {
            this.myStringBuilder.append(" />\n");
        } else {
            this.indent();
            this.myStringBuilder.append("</").append(name).append(">\n");
        }
        this.myLastAppendedConstruct = Construct.END_TAG;
        return this;
    }

    private void indent() {
        for (int i = 0; i < this.myIndentationLevel; ++i) {
            this.myStringBuilder.append("    ");
        }
    }

    @NotNull
    public String toString() {
        return this.myStringBuilder.toString();
    }

    private static enum Construct {
        NULL,
        START_TAG,
        ATTRIBUTE,
        END_TAG;

    }
}

