/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.uibuilder.handlers.constraint.WidgetNavigatorPanel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.ui.popup.JBPopup;
import icons.AndroidIcons;
import java.lang.ref.WeakReference;
import java.util.Locale;

public class TogglePanningDialogAction
extends ToggleAction {
    private final DesignSurface mySurface;
    WeakReference<JBPopup> myPopupReference;

    public TogglePanningDialogAction(DesignSurface surface) {
        this.mySurface = surface;
        String title = String.format(Locale.US, "%s %s", "Pan and Zoom", "(Scroll to Zoom)");
        this.getTemplatePresentation().setIcon(AndroidIcons.NeleIcons.Pan);
        this.getTemplatePresentation().setDescription(title);
        this.getTemplatePresentation().setText(title);
    }

    public boolean isSelected(AnActionEvent e) {
        if (this.myPopupReference == null) {
            return false;
        }
        JBPopup popup = (JBPopup)this.myPopupReference.get();
        return popup != null && popup.isVisible();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        JBPopup popup;
        if (state) {
            this.myPopupReference = new WeakReference<JBPopup>(WidgetNavigatorPanel.createPopup(this.mySurface));
        } else if (this.myPopupReference != null && (popup = (JBPopup)this.myPopupReference.get()) != null) {
            popup.cancel();
        }
    }
}

