/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SelectSiblingsAction
extends AnAction {
    private final SelectionModel myModel;

    public SelectSiblingsAction(@NotNull SelectionModel model) {
        super("Select Siblings", "Select Siblings", null);
        this.myModel = model;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(!this.myModel.isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        if (this.myModel.isEmpty()) {
            return;
        }
        Map<NlComponent, List<NlComponent>> map = NlModel.groupSiblings(this.myModel.getSelection());
        ArrayList allSiblings = Lists.newArrayList();
        for (NlComponent parent : map.keySet()) {
            Iterables.addAll((Collection)allSiblings, parent.getChildren());
        }
        this.myModel.setSelection(allSiblings);
    }
}

