/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.uibuilder.lint.LintAnnotationsModel;
import com.android.tools.idea.uibuilder.lint.LintNotificationPanel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LintNotificationAction
extends AnAction {
    private final DesignSurface mySurface;
    private int myCount = -1;

    public LintNotificationAction(@NotNull DesignSurface surface) {
        this.mySurface = surface;
    }

    public void update(AnActionEvent e) {
        LintAnnotationsModel lintModel;
        Presentation presentation = e.getPresentation();
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        int markerCount = 0;
        if (screenView != null && (lintModel = screenView.getModel().getLintAnnotationsModel()) != null) {
            markerCount = lintModel.getIssueCount();
        }
        if (markerCount != this.myCount) {
            Icon icon;
            this.myCount = markerCount;
            switch (markerCount) {
                case 0: {
                    icon = AndroidIcons.LintNotification.Lint0;
                    break;
                }
                case 1: {
                    icon = AndroidIcons.LintNotification.Lint1;
                    break;
                }
                case 2: {
                    icon = AndroidIcons.LintNotification.Lint2;
                    break;
                }
                case 3: {
                    icon = AndroidIcons.LintNotification.Lint3;
                    break;
                }
                case 4: {
                    icon = AndroidIcons.LintNotification.Lint4;
                    break;
                }
                case 5: {
                    icon = AndroidIcons.LintNotification.Lint5;
                    break;
                }
                case 6: {
                    icon = AndroidIcons.LintNotification.Lint6;
                    break;
                }
                case 7: {
                    icon = AndroidIcons.LintNotification.Lint7;
                    break;
                }
                case 8: {
                    icon = AndroidIcons.LintNotification.Lint8;
                    break;
                }
                case 9: {
                    icon = AndroidIcons.LintNotification.Lint9;
                    break;
                }
                default: {
                    icon = AndroidIcons.LintNotification.Lint9plus;
                }
            }
            presentation.setIcon(icon);
            presentation.setText(markerCount == 0 ? "No Warnings" : "Show Warnings and Errors");
        }
    }

    public void actionPerformed(AnActionEvent e) {
        LintAnnotationsModel lintModel;
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView != null && (lintModel = screenView.getModel().getLintAnnotationsModel()) != null && lintModel.getIssueCount() > 0) {
            new LintNotificationPanel(screenView, lintModel).show(e);
        }
    }
}

