/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public final class WizardUtils {
    @NotNull
    public static File getProjectLocationParent() {
        String parent = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (parent == null) {
            String child = ApplicationNamesInfo.getInstance().getFullProductName().replace(" ", "") + "Projects";
            return new File(SystemProperties.getUserHome(), child);
        }
        return new File(parent.replace('/', File.separatorChar));
    }

    @NotNull
    public static String toHtmlString(@NotNull String text) {
        if (!StringUtil.isEmpty((String)text) && !text.startsWith("<html>")) {
            return String.format("<html>%1$s</html>", text.trim());
        }
        return text;
    }

    @NotNull
    public static URL toUrl(@NotNull String urlAsString) {
        URL url;
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url;
    }
}

