/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.validation;

import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.validators.TrueValidator;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class ValidatorPanel
extends JPanel
implements Disposable {
    private static final String BLANK = " ";
    private final ListenerManager myListeners;
    private final Table<Validator.Severity, ObservableValue<?>, String> myMessages;
    private final BoolProperty myHasErrors;
    private JPanel myRootPanel;
    private JPanel mySouthPanel;
    private JBLabel myValidationLabel;

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JPanel innerPanel) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myMessages = HashBasedTable.create();
        this.myHasErrors = new BoolValueProperty();
        this.add(this.myRootPanel);
        this.myRootPanel.add(innerPanel);
        this.myValidationLabel.setName("ValidationLabel");
        this.myValidationLabel.setText(BLANK);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public <T> void registerValidator(final @NotNull ObservableValue<T> value, final @NotNull Validator<T> validator) {
        this.myListeners.listenAndFire(value, new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                Validator.Result result = validator.validate(value.get());
                ValidatorPanel.this.myMessages.column((Object)value).clear();
                if (result.getSeverity() != Validator.Severity.OK) {
                    ValidatorPanel.this.myMessages.put((Object)result.getSeverity(), (Object)value, (Object)result.getMessage());
                }
                ValidatorPanel.this.updateValidationLabel();
            }
        });
    }

    public void registerValidator(@NotNull ObservableValue<Boolean> value, @NotNull String errorMessage) {
        this.registerValidator(value, new TrueValidator(errorMessage));
    }

    public void registerValidator(@NotNull ObservableValue<Boolean> value, @NotNull Validator.Severity severity, @NotNull String errorMessage) {
        this.registerValidator(value, new TrueValidator(severity, errorMessage));
    }

    @NotNull
    public ObservableBool hasErrors() {
        return this.myHasErrors;
    }

    private void updateValidationLabel() {
        this.myHasErrors.set(false);
        this.myValidationLabel.setIcon(null);
        this.myValidationLabel.setText(BLANK);
        for (Validator.Severity severity : Validator.Severity.values()) {
            Iterator messages = this.myMessages.row((Object)severity).values().iterator();
            if (!messages.hasNext()) continue;
            this.myValidationLabel.setText((String)messages.next());
            this.myValidationLabel.setIcon(severity.getIcon());
            if (severity != Validator.Severity.ERROR) continue;
            this.myHasErrors.set(true);
        }
    }

    public void dispose() {
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 15));
        this.mySouthPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "South");
        this.myValidationLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

