/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ProportionalLayout
implements LayoutManager2 {
    public static final int DEFAULT_GAP = 10;
    private final ColumnDefinition[] myDefinitions;
    private final float[] myPercentages;
    private final int myVGap;
    private final Map<Component, Constraint> myConstraints = Maps.newHashMap();

    public static ProportionalLayout fromString(@NotNull String columnDefinitions) throws IllegalArgumentException {
        return ProportionalLayout.fromString(columnDefinitions, 10);
    }

    public static ProportionalLayout fromString(@NotNull String columnDefinitions, int vGap) throws IllegalArgumentException {
        ArrayList splits = Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)columnDefinitions));
        int numColumns = splits.size();
        ColumnDefinition[] definitions = new ColumnDefinition[numColumns];
        try {
            for (int i = 0; i < splits.size(); ++i) {
                int value;
                String s = (String)splits.get(i);
                if (s.equals("Fit")) {
                    definitions[i] = new ColumnDefinition(ColumnDefinition.Type.Fit);
                    continue;
                }
                if (s.endsWith("px")) {
                    value = Integer.parseInt(s.substring(0, s.length() - 2));
                    definitions[i] = new ColumnDefinition(ColumnDefinition.Type.Fixed, value);
                    continue;
                }
                if (s.equals("*")) {
                    definitions[i] = new ColumnDefinition(ColumnDefinition.Type.Proportional, 1);
                    continue;
                }
                if (s.endsWith("*")) {
                    value = Integer.parseInt(s.substring(0, s.length() - 1));
                    definitions[i] = new ColumnDefinition(ColumnDefinition.Type.Proportional, value);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Bad column definition: \"%1$s\" in \"%2$s\"", s, columnDefinitions));
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Bad column definition: \"%s\"", columnDefinitions));
        }
        return new ProportionalLayout(vGap, definitions);
    }

    public ProportionalLayout(int vGap, ColumnDefinition ... definitions) {
        this.myVGap = vGap;
        this.myDefinitions = definitions;
        this.myPercentages = new float[this.myDefinitions.length];
        float totalProportionalWidth = 0.0f;
        for (ColumnDefinition column : this.myDefinitions) {
            if (column.getType() != ColumnDefinition.Type.Proportional) continue;
            totalProportionalWidth += (float)column.getValue();
        }
        if (totalProportionalWidth > 0.0f) {
            for (int i = 0; i < this.myDefinitions.length; ++i) {
                ColumnDefinition column = definitions[i];
                if (column.getType() != ColumnDefinition.Type.Proportional) continue;
                this.myPercentages[i] = (float)column.getValue() / totalProportionalWidth;
            }
        }
    }

    public int getNumColumns() {
        return this.myDefinitions.length;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraint) {
        if (constraint == null || !(constraint instanceof Constraint)) {
            throw new IllegalArgumentException("Children of ProportionalLayouts must be added with a property constraint");
        }
        Constraint typedConstraint = (Constraint)constraint;
        if (typedConstraint.myCol + typedConstraint.myColSpan > this.myDefinitions.length) {
            throw new IllegalArgumentException(String.format("Component added with invalid column span. col: %1$d, span: %2$d, num cols: %3$d", typedConstraint.myCol, typedConstraint.myColSpan, this.myDefinitions.length));
        }
        this.myConstraints.put(comp, (Constraint)constraint);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.myConstraints.remove(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int[] widths = new int[this.myDefinitions.length];
        for (int i = 0; i < this.myDefinitions.length; ++i) {
            ColumnDefinition column = this.myDefinitions[i];
            if (column.getType() != ColumnDefinition.Type.Fixed) continue;
            widths[i] = column.getValue();
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int componentCount = parent.getComponentCount();
            int numRows = 1;
            for (int i = 0; i < componentCount; ++i) {
                Component comp = parent.getComponent(i);
                int row = this.myConstraints.get(comp).getRow();
                numRows = Math.max(row + 1, numRows);
            }
            int[] heights = new int[numRows];
            int maxDesiredSpace = 0;
            for (int i = 0; i < componentCount; ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                Dimension d = comp.getPreferredSize();
                int row = this.myConstraints.get(comp).getRow();
                heights[row] = Math.max(heights[row], d.height);
                int col = this.myConstraints.get(comp).getCol();
                int colspan = this.myConstraints.get(comp).getColSpan();
                ColumnDefinition column = this.myDefinitions[col];
                if (column.getType() == ColumnDefinition.Type.Fit && colspan == 1) {
                    widths[col] = Math.max(widths[col], d.width);
                    continue;
                }
                if (column.getType() != ColumnDefinition.Type.Proportional) continue;
                int desiredSpace = Math.round((float)d.width / this.myPercentages[col]);
                maxDesiredSpace = Math.max(maxDesiredSpace, desiredSpace);
            }
            int h = 0;
            for (int height : heights) {
                if (h > 0 && height > 0) {
                    h += this.myVGap;
                }
                h += height;
            }
            int w = maxDesiredSpace;
            for (int width : widths) {
                w += width;
            }
            return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int[] widths = new int[this.myDefinitions.length];
        for (int i = 0; i < this.myDefinitions.length; ++i) {
            ColumnDefinition column = this.myDefinitions[i];
            if (column.getType() != ColumnDefinition.Type.Fixed) continue;
            widths[i] = column.getValue();
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            Object comp;
            int i;
            Insets insets = parent.getInsets();
            int componentCount = parent.getComponentCount();
            int numRows = 1;
            for (i = 0; i < componentCount; ++i) {
                comp = parent.getComponent(i);
                int row = this.myConstraints.get(comp).getRow();
                numRows = Math.max(row + 1, numRows);
            }
            int[] heights = new int[numRows];
            for (i = 0; i < componentCount; ++i) {
                comp = parent.getComponent(i);
                if (!((Component)comp).isVisible()) continue;
                Dimension d = ((Component)comp).getMinimumSize();
                int row = this.myConstraints.get(comp).getRow();
                heights[row] = Math.max(heights[row], d.height);
                int col = this.myConstraints.get(comp).getCol();
                int colspan = this.myConstraints.get(comp).getColSpan();
                ColumnDefinition column = this.myDefinitions[col];
                if (column.getType() != ColumnDefinition.Type.Fit || colspan != 1) continue;
                widths[col] = Math.max(widths[col], d.width);
            }
            int h = 0;
            for (Object height : (Object)heights) {
                if (h > 0 && height > 0) {
                    h += this.myVGap;
                }
                h += height;
            }
            int w = 0;
            int[] nArray = widths;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                float width = nArray[j];
                w = (int)((float)w + width);
            }
            return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        int numCols = this.myDefinitions.length;
        int[] colXs = new int[numCols];
        int[] colWs = new int[numCols];
        for (int i = 0; i < this.myDefinitions.length; ++i) {
            ColumnDefinition column = this.myDefinitions[i];
            if (column.getType() != ColumnDefinition.Type.Fixed) continue;
            colWs[i] = column.getValue();
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            int i;
            Object comp;
            int i2;
            Insets insets = parent.getInsets();
            int componentCount = parent.getComponentCount();
            int numRows = 1;
            for (i2 = 0; i2 < componentCount; ++i2) {
                comp = parent.getComponent(i2);
                int row = this.myConstraints.get(comp).getRow();
                numRows = Math.max(numRows, row + 1);
            }
            int[] rowYs = new int[numRows];
            int[] rowHs = new int[numRows];
            for (i2 = 0; i2 < componentCount; ++i2) {
                comp = parent.getComponent(i2);
                if (!((Component)comp).isVisible()) continue;
                Dimension d = ((Component)comp).getMinimumSize();
                int row = this.myConstraints.get(comp).getRow();
                rowHs[row] = Math.max(rowHs[row], d.height);
                int col = this.myConstraints.get(comp).getCol();
                int colspan = this.myConstraints.get(comp).getColSpan();
                ColumnDefinition column = this.myDefinitions[col];
                if (column.getType() != ColumnDefinition.Type.Fit || colspan != 1) continue;
                colWs[col] = Math.max(colWs[col], d.width);
            }
            int leftoverWidth = parent.getWidth() - insets.right - insets.left;
            for (Object colW : (Object)colWs) {
                leftoverWidth -= colW;
            }
            if (leftoverWidth > 0) {
                for (int i3 = 0; i3 < numCols; ++i3) {
                    if (!(this.myPercentages[i3] > 0.0f)) continue;
                    colWs[i3] = Math.round(this.myPercentages[i3] * (float)leftoverWidth);
                }
            }
            rowYs[0] = insets.top;
            for (i = 1; i < rowYs.length; ++i) {
                rowYs[i] = rowYs[i - 1] + rowHs[i - 1];
                if (rowHs[i] <= 0 || rowYs[i] <= insets.top) continue;
                int n = i;
                rowYs[n] = rowYs[n] + this.myVGap;
            }
            colXs[0] = insets.left;
            for (i = 1; i < colXs.length; ++i) {
                colXs[i] = colXs[i - 1] + colWs[i - 1];
            }
            for (i = 0; i < componentCount; ++i) {
                Component comp2 = parent.getComponent(i);
                if (!comp2.isVisible()) continue;
                int col = this.myConstraints.get(comp2).getCol();
                int colspan = this.myConstraints.get(comp2).getColSpan();
                int row = this.myConstraints.get(comp2).getRow();
                int totalWidth = 0;
                for (int currCol = col; currCol < col + colspan; ++currCol) {
                    totalWidth += colWs[currCol];
                }
                comp2.setBounds(colXs[col], rowYs[row], totalWidth, rowHs[row]);
            }
        }
    }

    public static final class Constraint {
        private final int myRow;
        private final int myCol;
        private final int myColSpan;

        public Constraint(int row, int col) {
            this(row, col, 1);
        }

        public Constraint(int row, int col, int colSpan) {
            if (colSpan < 1) {
                throw new IllegalArgumentException("ProportionalLayout column span must be greater than 0");
            }
            this.myRow = row;
            this.myCol = col;
            this.myColSpan = colSpan;
        }

        public int getRow() {
            return this.myRow;
        }

        public int getCol() {
            return this.myCol;
        }

        public int getColSpan() {
            return this.myColSpan;
        }
    }

    public static final class ColumnDefinition {
        private final Type myType;
        private final int myValue;

        public ColumnDefinition(Type type) {
            this(type, 0);
        }

        public ColumnDefinition(Type type, int value) {
            this.myType = type;
            this.myValue = value;
        }

        public Type getType() {
            return this.myType;
        }

        public int getValue() {
            return this.myValue;
        }

        public static enum Type {
            Fit,
            Fixed,
            Proportional;

        }
    }
}

