/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.templates.SupportLibrary;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryUrlManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.RepositoryUrlManager");
    public static final String TAG_VERSION = "version";
    public static final String REVISION_ANY = "0.0.+";
    private static final Ordering<GradleCoordinate> GRADLE_COORDINATE_ORDERING = Ordering.from((Comparator)GradleCoordinate.COMPARE_PLUS_LOWER);

    public static RepositoryUrlManager get() {
        return new RepositoryUrlManager();
    }

    RepositoryUrlManager() {
    }

    @Nullable
    public String getLibraryStringCoordinate(SupportLibrary library, boolean preview) {
        AndroidSdkData sdk = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdk == null) {
            return null;
        }
        String revision = this.getLibraryRevision(library.getGroupId(), library.getArtifactId(), null, preview, sdk.getLocation(), FileOpUtils.create());
        if (revision == null) {
            return null;
        }
        return library.getGradleCoordinate(revision).toString();
    }

    @Nullable
    public String getLibraryRevision(@NotNull String groupId, @NotNull String artifactId, @Nullable String filterPrefix, boolean includePreviews, @NotNull File sdkLocation, @NotNull FileOp fileOp) {
        GradleCoordinate versionInCombined;
        File combinedRepo = FileUtils.join((File)sdkLocation, (String[])new String[]{"extras", "m2repository"});
        if (fileOp.isDirectory(combinedRepo) && (versionInCombined = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (File)combinedRepo, (String)filterPrefix, (boolean)includePreviews, (FileOp)fileOp)) != null) {
            return versionInCombined.getRevision();
        }
        SdkMavenRepository repository = SdkMavenRepository.find((File)sdkLocation, (String)groupId, (String)artifactId, (FileOp)fileOp);
        if (repository == null) {
            List<File> paths = EmbeddedDistributionPaths.findAndroidStudioLocalMavenRepoPaths();
            for (File path : paths) {
                GradleCoordinate versionInEmbedded;
                if (path == null || !path.isDirectory() || (versionInEmbedded = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (File)path, (String)filterPrefix, (boolean)includePreviews, (FileOp)fileOp)) == null) continue;
                return versionInEmbedded.getRevision();
            }
            return null;
        }
        File repositoryLocation = repository.getRepositoryLocation(sdkLocation, true, fileOp);
        if (repositoryLocation == null) {
            return null;
        }
        File mavenMetadataFile = MavenRepositories.getMavenMetadataFile((File)repositoryLocation, (String)groupId, (String)artifactId);
        if (fileOp.isFile(mavenMetadataFile)) {
            try {
                return RepositoryUrlManager.getLatestVersionFromMavenMetadata(mavenMetadataFile, filterPrefix, includePreviews, fileOp);
            }
            catch (IOException e) {
                return null;
            }
        }
        GradleCoordinate max = repository.getHighestInstalledVersion(sdkLocation, groupId, artifactId, filterPrefix, includePreviews, fileOp);
        if (max == null) {
            return null;
        }
        return max.getRevision();
    }

    @Nullable
    public File getArchiveForCoordinate(@NotNull GradleCoordinate gradleCoordinate, @NotNull File sdkLocation, @NotNull FileOp fileOp) {
        if (gradleCoordinate.getGroupId() == null || gradleCoordinate.getArtifactId() == null) {
            return null;
        }
        SdkMavenRepository repository = SdkMavenRepository.find((File)sdkLocation, (String)gradleCoordinate.getGroupId(), (String)gradleCoordinate.getArtifactId(), (FileOp)fileOp);
        if (repository == null) {
            return null;
        }
        File repositoryLocation = repository.getRepositoryLocation(sdkLocation, true, fileOp);
        if (repositoryLocation == null) {
            return null;
        }
        File artifactDirectory = MavenRepositories.getArtifactDirectory((File)repositoryLocation, (GradleCoordinate)gradleCoordinate);
        if (!fileOp.isDirectory(artifactDirectory)) {
            return null;
        }
        for (GradleCoordinate.ArtifactType artifactType : ImmutableList.of((Object)GradleCoordinate.ArtifactType.JAR, (Object)GradleCoordinate.ArtifactType.AAR)) {
            File archive = new File(artifactDirectory, String.format("%s-%s.%s", gradleCoordinate.getArtifactId(), gradleCoordinate.getRevision(), artifactType.toString()));
            if (!fileOp.isFile(archive)) continue;
            return archive;
        }
        return null;
    }

    @Nullable
    private static String getLatestVersionFromMavenMetadata(final @NotNull File metadataFile, final @Nullable String filterPrefix, final boolean includePreviews, @NotNull FileOp fileOp) throws IOException {
        String xml = fileOp.toString(metadataFile, StandardCharsets.UTF_8);
        final LinkedList versions = Lists.newLinkedList();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(IOUtils.toInputStream((String)xml), new DefaultHandler(){
                boolean inVersionTag = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals(RepositoryUrlManager.TAG_VERSION)) {
                        this.inVersionTag = true;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.inVersionTag) {
                        this.inVersionTag = false;
                        String revision = new String(ch, start, length);
                        if (!(!includePreviews && "5.2.08".equals(revision) && metadataFile.getPath().contains(SupportLibrary.PLAY_SERVICES.getArtifactId()) || filterPrefix != null && !revision.startsWith(filterPrefix))) {
                            versions.add(GradleCoordinate.parseVersionOnly((String)revision));
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (versions.isEmpty()) {
            return REVISION_ANY;
        }
        if (includePreviews) {
            return ((GradleCoordinate)GRADLE_COORDINATE_ORDERING.max((Iterable)versions)).getRevision();
        }
        return versions.stream().filter(v -> !v.isPreview()).max((Comparator<GradleCoordinate>)GRADLE_COORDINATE_ORDERING).map(GradleCoordinate::getRevision).orElse(null);
    }

    @Nullable
    public GradleCoordinate resolveDynamicCoordinate(@NotNull GradleCoordinate coordinate, @Nullable Project project) {
        return this.resolveDynamicCoordinate(coordinate, project, AndroidSdkUtils.tryToChooseSdkHandler());
    }

    @Nullable
    public GradleCoordinate resolveDynamicCoordinate(@NotNull GradleCoordinate coordinate, @Nullable Project project, @NotNull AndroidSdkHandler sdkHandler) {
        List revisions;
        String version = this.resolveDynamicCoordinateVersion(coordinate, project, sdkHandler);
        if (version != null && coordinate.getGroupId() != null && coordinate.getArtifactId() != null && !(revisions = GradleCoordinate.parseRevisionNumber((String)version)).isEmpty()) {
            return new GradleCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), revisions, coordinate.getArtifactType());
        }
        return null;
    }

    @Nullable
    public String resolveDynamicCoordinateVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project) {
        return this.resolveDynamicCoordinateVersion(coordinate, project, AndroidSdkUtils.tryToChooseSdkHandler());
    }

    @Nullable
    String resolveDynamicCoordinateVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project, @NotNull AndroidSdkHandler sdkHandler) {
        String version;
        IntellijLintClient client;
        Revision latest;
        GradleCoordinate found;
        if (coordinate.getGroupId() == null || coordinate.getArtifactId() == null) {
            return null;
        }
        String filter = coordinate.getRevision();
        if (!filter.endsWith("+")) {
            return filter;
        }
        filter = filter.substring(0, filter.length() - 1);
        File sdkLocation = sdkHandler.getLocation();
        if (sdkLocation != null) {
            String libraryCoordinate = this.getLibraryRevision(coordinate.getGroupId(), coordinate.getArtifactId(), filter, false, sdkLocation, sdkHandler.getFileOp());
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
            libraryCoordinate = this.getLibraryRevision(coordinate.getGroupId(), coordinate.getArtifactId(), filter, true, sdkLocation, sdkHandler.getFileOp());
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
        }
        if ((found = GradleUtil.findLatestVersionInGradleCache(coordinate, filter, project)) != null) {
            return found.getRevision();
        }
        RemotePackage sdkPackage = SdkMavenRepository.findLatestRemoteVersion((GradleCoordinate)coordinate, (AndroidSdkHandler)sdkHandler, (ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        if (sdkPackage != null && (found = SdkMavenRepository.getCoordinateFromSdkPath((String)sdkPackage.getPath())) != null) {
            return found.getRevision();
        }
        if (project != null && (latest = GradleDetector.getLatestVersionFromRemoteRepo((LintClient)(client = new IntellijLintClient(project)), (GradleCoordinate)coordinate, (boolean)coordinate.isPreview())) != null && (version = latest.toShortString()).startsWith(filter)) {
            return version;
        }
        return null;
    }

    public List<GradleCoordinate> resolveDynamicSdkDependencies(@NotNull Multimap<String, GradleCoordinate> dependencies, @Nullable String supportLibVersionFilter, @NotNull AndroidSdkData sdk) {
        FileOp fileOp = FileOpUtils.create();
        ArrayList result = Lists.newArrayListWithCapacity((int)dependencies.size());
        for (String key : dependencies.keySet()) {
            GradleCoordinate highest = (GradleCoordinate)Collections.max(dependencies.get((Object)key), GradleCoordinate.COMPARE_PLUS_LOWER);
            if (highest.getGroupId() == null || highest.getArtifactId() == null) {
                return null;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() || Boolean.getBoolean("force.gradlemerger.repository.check")) {
                File archiveFile;
                String libraryCoordinate;
                GradleCoordinate available;
                String filter = highest.getGroupId() != null && "com.android.support".equals(highest.getGroupId()) ? supportLibVersionFilter : null;
                String version = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), filter, true, sdk.getLocation(), fileOp);
                if (version == null && filter != null) {
                    version = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), null, true, sdk.getLocation(), fileOp);
                }
                if (version != null && (available = GradleCoordinate.parseCoordinateString((String)(libraryCoordinate = highest.getId() + ":" + version))) != null && ((archiveFile = this.getArchiveForCoordinate(available, sdk.getLocation(), fileOp)) != null && archiveFile.exists() || SupportLibrary.forGradleCoordinate(available) == null) && GradleCoordinate.COMPARE_PLUS_LOWER.compare(available, highest) >= 0) {
                    highest = available;
                }
            }
            result.add(highest);
        }
        return result;
    }
}

