/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.structure.services.DeveloperServices;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeveloperServiceMap {
    private HashMap<String, DeveloperServiceList> myServiceCache = new HashMap();

    public DeveloperServiceMap(@NotNull Set<Module> modules) {
        for (Module module : modules) {
            for (DeveloperService service : DeveloperServices.getAll(module)) {
                this.put(service.getMetadata().getId(), service);
            }
        }
    }

    private void put(@NotNull String key, @NotNull DeveloperService service) {
        if (this.myServiceCache.containsKey(key)) {
            List developerServices = this.myServiceCache.get(key);
            developerServices.add(service);
            return;
        }
        DeveloperServiceList services = new DeveloperServiceList();
        services.add(service);
        this.myServiceCache.put(key, services);
    }

    @Nullable(value="Null when key doesn't match known services")
    public DeveloperServiceList get(@NotNull String key) {
        return this.myServiceCache.get(key);
    }

    @Nullable(value="Null if no pairing found.")
    public DeveloperService get(@NotNull String key, @NotNull Module module) {
        List services = this.myServiceCache.get(key);
        for (DeveloperService service : services) {
            if (!service.getModule().equals(module)) continue;
            return service;
        }
        DeveloperServiceMap.getLog().error("No service found for module " + module.getName());
        return null;
    }

    private static Logger getLog() {
        return Logger.getInstance(DeveloperServiceMap.class);
    }

    public static class DeveloperServiceList
    extends ArrayList<DeveloperService> {
        private Set<Module> myModules = new HashSet<Module>();

        @Nullable(value="Null if no pairing found.")
        public DeveloperService get(@NotNull Module module) {
            for (DeveloperService service : this) {
                if (!service.getModule().equals(module)) continue;
                return service;
            }
            DeveloperServiceMap.getLog().error("No service found for module " + module.getName());
            return null;
        }

        @Nullable(value="Null when no services found.")
        public Project getProject() {
            if (this.size() == 0) {
                return null;
            }
            return ((DeveloperService)this.get(0)).getModule().getProject();
        }

        @Nullable(value="If no service in list.")
        public DeveloperServiceMetadata getMetadata() {
            if (this.size() == 0) {
                return null;
            }
            return ((DeveloperService)this.get(0)).getMetadata();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<Module> getModules() {
            DeveloperServiceList developerServiceList = this;
            synchronized (developerServiceList) {
                if (this.myModules.isEmpty()) {
                    for (DeveloperService service : this) {
                        this.myModules.add(service.getModule());
                    }
                }
            }
            return this.myModules;
        }
    }
}

