/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.Anonymizer;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.idea.stats.UsageUploader;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.HashMap;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageTrackerAnalyticsImpl
extends UsageTracker {
    private static final ExtensionPointName<UsageUploader> EP_NAME = ExtensionPointName.create((String)"com.android.tools.idea.stats.tracker");
    private static final String GLOGS_CATEGORY_LIBCOUNT = "gradlelibs";
    private static final String GLOGS_CATEGORY_MODUDLE_COUNT = "gradlemodules";
    private static final String GLOGS_CATEGORY_ANDROID_MODUDLE = "gradleAndroidModule";
    private static final String GLOGS_CATEGORY_NATIVE_BUILD_SYSTEM = "gradleNativeBuildSystem";
    private static final String GLOGS_CATEGORY_VERSIONS = "gradleVersions";
    private static final String GLOGS_CATEGORY_LEGACY_IDEA_ANDROID_PROJECT = "legacyIdeaAndroidProject";
    private static final String GLOGS_CATEGORY_INSTANT_RUN = "irstats2";
    private static final String GLOGS_CATEGORY_INSTANT_RUN_TIMINGS = "irtimings";
    private static final String GLOGS_CATEGORY_SYSTEM_INFO = "systeminfo";
    private static final String GLOGS_CATEGORY_APK_ANALYZER = "apkAnalyzer";
    private static final String ANONYMIZATION_ISSUE = "*ANONYMIZATION_ISSUE*";
    private final UsageUploader myUploader;
    private static final Logger INTELLIJ_LOGGER = Logger.getInstance((String)"#com.android.tools.idea.stats.UsageTrackerAnalyticsImpl.class");
    private static final ILogger LOGGER = new ILogger(){

        public void error(@Nullable Throwable t, String msgFormat, Object ... args) {
            INTELLIJ_LOGGER.error(String.format(msgFormat, args), t);
        }

        public void warning(@NotNull String msgFormat, Object ... args) {
            INTELLIJ_LOGGER.warn(String.format(msgFormat, args));
        }

        public void info(@NotNull String msgFormat, Object ... args) {
            INTELLIJ_LOGGER.info(String.format(msgFormat, args));
        }

        public void verbose(@NotNull String msgFormat, Object ... args) {
            this.info(msgFormat, args);
        }
    };

    public UsageTrackerAnalyticsImpl() {
        UsageUploader[] uploaders = (UsageUploader[])EP_NAME.getExtensions();
        this.myUploader = uploaders.length > 0 ? uploaders[0] : null;
    }

    private boolean trackingEnabled() {
        return this.myUploader != null && this.canTrack();
    }

    @Override
    public void trackEvent(@NotNull String eventCategory, @NotNull String eventAction, @Nullable String eventLabel, @Nullable Integer eventValue) {
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(eventCategory, eventAction, eventLabel, eventValue);
    }

    @Override
    public void trackLibraryCount(@NotNull String applicationId, int jarDependencyCount, int aarDependencyCount) {
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_LIBCOUNT, (Map<String, String>)ImmutableMap.of((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId), (Object)"jars", (Object)Integer.toString(jarDependencyCount), (Object)"aars", (Object)Integer.toString(aarDependencyCount)));
    }

    @Override
    public void trackModuleCount(@NotNull String applicationId, int total, int appModuleCount, int libModuleCount) {
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_MODUDLE_COUNT, (Map<String, String>)ImmutableMap.of((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId), (Object)"total", (Object)String.valueOf(total), (Object)"apps", (Object)String.valueOf(appModuleCount), (Object)"libs", (Object)String.valueOf(libModuleCount)));
    }

    @Override
    public void trackAndroidModule(@NotNull String applicationId, @NotNull String moduleName, boolean isLibrary, int signingConfigCount, int buildTypeCount, int flavorCount, int flavorDimension) {
        if (!this.trackingEnabled()) {
            return;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId));
        builder.put((Object)"moduleName", (Object)UsageTrackerAnalyticsImpl.anonymize(moduleName));
        builder.put((Object)"isLibrary", (Object)String.valueOf(isLibrary));
        builder.put((Object)"buildTypeCount", (Object)String.valueOf(buildTypeCount));
        builder.put((Object)"flavorCount", (Object)String.valueOf(flavorCount));
        builder.put((Object)"flavorDimension", (Object)String.valueOf(flavorDimension));
        this.myUploader.trackEvent(GLOGS_CATEGORY_ANDROID_MODUDLE, (Map<String, String>)builder.build());
    }

    @Override
    public void trackNativeBuildSystem(@NotNull String applicationId, @NotNull String moduleName, @NotNull String buildSystem) {
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_NATIVE_BUILD_SYSTEM, (Map<String, String>)ImmutableMap.of((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId), (Object)"moduleName", (Object)UsageTrackerAnalyticsImpl.anonymize(moduleName), (Object)"buildSystem", (Object)buildSystem));
    }

    @Override
    public void trackGradleArtifactVersions(@NotNull String applicationId, @NotNull String androidPluginVersion, @NotNull String gradleVersion, @NotNull Map<String, String> instantRunSettings) {
        if (!this.trackingEnabled()) {
            return;
        }
        ImmutableMap params = ImmutableMap.builder().put((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId)).put((Object)"pluginVer", (Object)androidPluginVersion).put((Object)"gradleVer", (Object)gradleVersion).putAll(instantRunSettings).build();
        this.myUploader.trackEvent(GLOGS_CATEGORY_VERSIONS, (Map<String, String>)params);
    }

    @Override
    public void trackLegacyIdeaAndroidProject(@NotNull String applicationId) {
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_LEGACY_IDEA_ANDROID_PROJECT, (Map<String, String>)ImmutableMap.of((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId)));
    }

    @Override
    public void trackInstantRunStats(@NotNull Map<String, String> kv) {
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_INSTANT_RUN, kv);
    }

    @Override
    public void trackInstantRunTimings(@NotNull Map<String, String> kv) {
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_INSTANT_RUN_TIMINGS, kv);
    }

    @Override
    public void trackSystemInfo(@Nullable String hyperVState, @Nullable String cpuInfoFlags) {
        if (!this.trackingEnabled()) {
            return;
        }
        HashMap kv = new HashMap();
        if (hyperVState != null) {
            kv.put((Object)"hvstate", (Object)hyperVState);
        }
        if (cpuInfoFlags != null) {
            kv.put((Object)"cpuflags", (Object)cpuInfoFlags);
        }
        kv.put((Object)"os", (Object)SystemInfo.OS_NAME);
        kv.put((Object)"bits", (Object)(SystemInfo.is64Bit || SystemInfo.OS_ARCH.contains("64") ? "64" : "32"));
        this.myUploader.trackEvent(GLOGS_CATEGORY_SYSTEM_INFO, (Map<String, String>)kv);
    }

    @Override
    public void trackPSDEvent(@NotNull String applicationId, @NotNull String eventAction, @Nullable String eventLabel) {
        if (!this.trackingEnabled()) {
            return;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId)).put((Object)"eventAction", (Object)eventAction);
        if (eventLabel != null) {
            builder.put((Object)"eventLabel", (Object)eventLabel);
        }
        this.myUploader.trackEvent("projectStructureDialog", (Map<String, String>)builder.build());
    }

    @Override
    public void trackApkAnalyzerEvent(@NotNull String applicationId, long uncompressedSize, long compressedSize) {
        if (!this.trackingEnabled()) {
            return;
        }
        ImmutableMap params = ImmutableMap.of((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId), (Object)"rawSize", (Object)Long.toString(uncompressedSize), (Object)"zipSize", (Object)Long.toString(compressedSize));
        this.myUploader.trackEvent(GLOGS_CATEGORY_APK_ANALYZER, (Map<String, String>)params);
    }

    @NotNull
    private static String anonymize(@NotNull String applicationId) {
        try {
            return Anonymizer.anonymizeUtf8((ILogger)LOGGER, (String)applicationId);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e, "Unable to update anonymization salt.", new Object[0]);
            return ANONYMIZATION_ISSUE;
        }
    }
}

