/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.idea.stats.DdmsPreferenceStore;
import com.android.tools.idea.stats.OsInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacySdkStatsService {
    private static final Logger LOG = Logger.getInstance((String)("#" + LegacySdkStatsService.class.getName()));
    protected static final String SYS_PROP_OS_ARCH = "os.arch";
    protected static final String SYS_PROP_JAVA_VERSION = "java.version";
    protected static final String SYS_PROP_OS_VERSION = "os.version";
    protected static final String SYS_PROP_OS_NAME = "os.name";
    private static final long PING_INTERVAL_MSEC = 86400000L;
    private static final boolean DEBUG = System.getenv("ANDROID_DEBUG_PING") != null;
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication() == null;
    private static final String INSTALLATION_ID = UNIT_TEST_MODE ? "unit-test" : UpdateChecker.getInstallationUID((PropertiesComponent)PropertiesComponent.getInstance());
    private DdmsPreferenceStore mStore = new DdmsPreferenceStore();

    public void ping(@NotNull String app, @NotNull String version) {
        this.doPing(app, version, null);
    }

    protected void doPing(@NotNull String app, @NotNull String version, @Nullable Map<String, String> extras) {
        long then;
        String nApp = this.normalizeAppName(app);
        String nVersion = this.normalizeVersion(version);
        if (!this.mStore.isPingOptIn()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - (then = this.mStore.getPingTime(app)) < 86400000L) {
            return;
        }
        this.mStore.setPingTime(app, now);
        try {
            URL url = this.createPingUrl(nApp, nVersion, INSTALLATION_ID, extras);
            this.actuallySendPing(url);
        }
        catch (Exception e) {
            LOG.warn("AndroidSdk.SendPing failed", (Throwable)e);
        }
    }

    private void actuallySendPing(URL url) throws IOException {
        int responseCode;
        assert (url != null);
        if (DEBUG) {
            LOG.debug("Ping: " + url.toString());
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            responseCode = conn.getResponseCode();
        }
        catch (UnknownHostException e) {
            responseCode = 400;
        }
        if (responseCode != 200 && responseCode != 404) {
            throw new IOException(conn.getResponseMessage() + ": " + url);
        }
    }

    protected URL createPingUrl(@NotNull String app, @NotNull String version, @NotNull String id, @Nullable Map<String, String> extras) throws UnsupportedEncodingException, MalformedURLException {
        String osName = URLEncoder.encode(this.getOsName().getOsFull(), "UTF-8");
        String osArch = URLEncoder.encode(this.getOsArch(), "UTF-8");
        String jvmArch = URLEncoder.encode(this.getJvmInfo(), "UTF-8");
        String extraStr = "";
        if (extras != null && !extras.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : extras.entrySet()) {
                sb.append('&').append(entry.getKey()).append('=').append(entry.getValue());
            }
            extraStr = sb.toString();
        }
        URL url = new URL("http", "tools.google.com", "/service/update?as=androidsdk_" + app + "&id=" + id + "&version=" + version + "&os=" + osName + "&osa=" + osArch + "&vma=" + jvmArch + extraStr);
        return url;
    }

    OsInfo getOsName() {
        String os = this.getSystemProperty(SYS_PROP_OS_NAME);
        OsInfo info = new OsInfo();
        if (os == null || os.length() == 0) {
            return info.setOsName("unknown");
        }
        String os2 = os.toLowerCase(Locale.US);
        String osVers = null;
        if (os2.startsWith("mac")) {
            os = "mac";
            osVers = this.getOsVersion();
        } else if (os2.startsWith("win")) {
            os = "win";
            osVers = this.getOsVersion();
        } else if (os2.startsWith("linux")) {
            os = "linux";
        } else if (os.length() > 32) {
            os = os.substring(0, 32);
        }
        info.setOsName(os);
        info.setOsVersion(osVers);
        return info;
    }

    String getOsArch() {
        String arch = this.getJvmArch();
        if ("x86_64".equals(arch)) {
            return arch;
        }
        if ("x86".equals(arch)) {
            String os = this.getOsName().getOsName();
            if (os.startsWith("win")) {
                String w6432 = this.getSystemEnv("PROCESSOR_ARCHITEW6432");
                if (w6432 != null && w6432.contains("64")) {
                    return "x86_64";
                }
            } else if (os.startsWith("linux")) {
                String s = this.getSystemEnv("HOSTTYPE");
                if ((s = this.sanitizeOsArch(s)).contains("86")) {
                    arch = s;
                }
            }
        }
        return arch;
    }

    @Nullable
    String getOsVersion() {
        Matcher m;
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+).*");
        String osVers = this.getSystemProperty(SYS_PROP_OS_VERSION);
        if (osVers != null && osVers.length() > 0 && (m = p.matcher(osVers)).matches()) {
            return m.group(1) + '.' + m.group(2);
        }
        return null;
    }

    String getJvmInfo() {
        return this.getJvmVersion() + '-' + this.getJvmArch();
    }

    String getJvmVersion() {
        String version = this.getSystemProperty(SYS_PROP_JAVA_VERSION);
        if (version == null || version.length() == 0) {
            return "unknown";
        }
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+).*");
        Matcher m = p.matcher(version);
        if (m.matches()) {
            return m.group(1) + '.' + m.group(2);
        }
        if (version.length() > 8) {
            version = version.substring(0, 8);
        }
        return version;
    }

    String getJvmArch() {
        String arch = this.getSystemProperty(SYS_PROP_OS_ARCH);
        return this.sanitizeOsArch(arch);
    }

    private String sanitizeOsArch(String arch) {
        if (arch == null || arch.length() == 0) {
            return "unknown";
        }
        if (arch.equalsIgnoreCase("x86_64") || arch.equalsIgnoreCase("ia64") || arch.equalsIgnoreCase("amd64")) {
            return "x86_64";
        }
        if (arch.length() >= 4 && arch.charAt(0) == 'i' && arch.indexOf("86") == 2) {
            return "x86";
        }
        if (arch.equalsIgnoreCase("PowerPC")) {
            return "ppc";
        }
        if (arch.length() > 32) {
            arch = arch.substring(0, 32);
        }
        return arch;
    }

    protected String normalizeAppName(String app) {
        String app2 = app.replaceAll("\\W", "");
        if (app.length() == 0) {
            throw new IllegalArgumentException("Bad app name: " + app);
        }
        return app2;
    }

    protected String normalizeVersion(String version) {
        Pattern regex = Pattern.compile("^(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+)| +rc(\\d+))?");
        Matcher m = regex.matcher(version);
        if (m != null && m.lookingAt()) {
            StringBuilder normal = new StringBuilder();
            for (int i = 1; i <= 4; ++i) {
                int v = 0;
                if (i == 4 && i < m.groupCount() && m.group(i) == null && m.group(i + 1) != null) {
                    ++i;
                }
                if (m.group(i) != null) {
                    try {
                        v = Integer.parseInt(m.group(i));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (i > 1) {
                    normal.append('.');
                }
                normal.append(v);
            }
            return normal.toString();
        }
        throw new IllegalArgumentException("Bad version: " + version);
    }

    protected String getSystemProperty(String name) {
        return System.getProperty(name);
    }

    protected String getSystemEnv(String name) {
        return System.getenv(name);
    }
}

