/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ExternalAnnotationsSupport {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotationsSupport.class);
    private static final String[] DEVELOPMENT_ANNOTATIONS_PATHS = new String[]{"/../adt/idea/android/annotations", "/android/android/annotations", "/community/android/android/annotations"};

    private static void checkAnnotationsJarAttached(@NotNull PsiFile file, @NotNull ProblemsHolder holder) {
    }

    public static void attachJdkAnnotations(@NotNull SdkModificator modificator) {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        String releaseLocation = homePath + "/plugins/android/lib/androidAnnotations.jar";
        VirtualFile root = fileManager.findFileByUrl("jar://" + releaseLocation + "!/");
        for (String relativePath : DEVELOPMENT_ANNOTATIONS_PATHS) {
            if (root != null) break;
            String developmentLocation = homePath + relativePath;
            root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)developmentLocation));
        }
        if (root == null) {
            LOG.error("jdk annotations not found in: " + releaseLocation);
            return;
        }
        OrderRootType annoType = AnnotationOrderRootType.getInstance();
        modificator.removeRoot(root, annoType);
        modificator.addRoot(root, annoType);
    }

    public static void addAnnotations(@NotNull Sdk sdk) {
        SdkModificator modifier = sdk.getSdkModificator();
        ExternalAnnotationsSupport.attachJdkAnnotations(modifier);
        modifier.commitChanges();
    }

    public static void addAnnotationsIfNecessary(@NotNull Sdk sdk) {
        VirtualFile[] roots = sdk.getRootProvider().getFiles(AnnotationOrderRootType.getInstance());
        if (roots.length > 0) {
            return;
        }
        SdkModificator modifier = sdk.getSdkModificator();
        ExternalAnnotationsSupport.attachJdkAnnotations(modifier);
        modifier.commitChanges();
    }
}

