/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Uninstaller;
import com.android.repository.impl.installer.AbstractInstallerFactory;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.install.patch.FullInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchRunner;
import com.android.tools.idea.sdk.install.patch.PatchUninstaller;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import org.jetbrains.annotations.NotNull;

public class PatchInstallerFactory
extends AbstractInstallerFactory {
    @NotNull
    protected Installer doCreateInstaller(@NotNull RemotePackage p, @NotNull RepoManager mgr, @NotNull Downloader downloader, @NotNull FileOp fop) {
        LocalPackage local = (LocalPackage)mgr.getPackages().getLocalPackages().get(p.getPath());
        Archive archive = p.getArchive();
        assert (archive != null);
        if (local != null && archive.getPatch(local.getVersion()) != null) {
            return new PatchInstaller(local, p, downloader, mgr, fop);
        }
        return new FullInstaller(local, p, mgr, downloader, fop);
    }

    @NotNull
    protected Uninstaller doCreateUninstaller(@NotNull LocalPackage p, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        return new PatchUninstaller(p, mgr, fop);
    }

    public static boolean canHandlePackage(@NotNull RepoPackage p, @NotNull AndroidSdkHandler handler) {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(PatchInstallerFactory.class);
        RepoManager mgr = handler.getSdkManager((ProgressIndicator)progress);
        if (p instanceof LocalPackage) {
            return PatchInstallerUtil.getLatestPatcher(mgr) != null;
        }
        LocalPackage patcher = PatchInstallerUtil.getDependantPatcher((RemotePackage)p, mgr);
        return patcher != null && PatchRunner.getPatchRunner(patcher, (ProgressIndicator)progress, handler.getFileOp()) != null;
    }
}

