/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install;

import com.android.repository.api.InstallerFactory;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.installer.BasicInstallerFactory;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.install.StudioSdkInstallListenerFactory;
import com.android.tools.idea.sdk.install.patch.PatchInstallerFactory;
import org.jetbrains.annotations.NotNull;

public final class StudioSdkInstallerUtil {
    @NotNull
    public static InstallerFactory createInstallerFactory(@NotNull RepoPackage p, @NotNull AndroidSdkHandler sdkHandler) {
        Object factory = null;
        if (Boolean.getBoolean("sdk.patches") && PatchInstallerFactory.canHandlePackage(p, sdkHandler)) {
            factory = new PatchInstallerFactory();
        }
        if (factory == null) {
            factory = new BasicInstallerFactory();
        }
        factory.setListenerFactory((InstallerFactory.StatusChangeListenerFactory)new StudioSdkInstallListenerFactory(sdkHandler));
        return factory;
    }

    private StudioSdkInstallerUtil() {
    }
}

