/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install;

import com.android.SdkConstants;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.ddms.adb.AdbService;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class PlatformToolsInstallListener
implements PackageOperation.StatusChangeListener {
    private final AndroidSdkHandler mySdkHandler;

    public PlatformToolsInstallListener(AndroidSdkHandler sdkHandler) {
        this.mySdkHandler = sdkHandler;
    }

    private void stopAdb(ProgressIndicator progress) {
        AdbService adbService = AdbService.getInstance();
        progress.logInfo("Stopping ADB...");
        File adb = this.getAdb(progress);
        if (adb != null) {
            try {
                adbService.getDebugBridge(adb).get();
            }
            catch (Exception e) {
                progress.logWarning("Failed to get ADB instance", (Throwable)e);
            }
        }
        adbService.terminateDdmlib();
    }

    private File getAdb(@NotNull ProgressIndicator progress) {
        LocalPackage localPackage = this.mySdkHandler.getLocalPackage("platform-tools", progress);
        if (localPackage != null) {
            return new File(localPackage.getLocation().getPath(), SdkConstants.FN_ADB);
        }
        return null;
    }

    public void statusChanged(PackageOperation installer, ProgressIndicator progress) {
        if (installer.getInstallStatus() == PackageOperation.InstallStatus.RUNNING) {
            this.stopAdb(progress);
        }
    }
}

