/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.SdkConstants;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.startup.AndroidSdkInitializer;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.base.Joiner;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.EnumSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemInfoStatsMonitor {
    private static final Logger LOG = Logger.getInstance(SystemInfoStatsMonitor.class);
    private static final int UPLOAD_INTERVAL_HOURS = 6;
    private static final Revision LOWEST_TOOLS_REVISION_HYPERV = new Revision(25, 0, 3);
    private static final Revision LOWEST_TOOLS_REVISION_CPU_INFO = new Revision(25, 1, 1);
    private static final int EMULATOR_CHECK_ERROR_EXIT_CODE = 100;
    private AndroidSdkHandler mySdkHandler = null;
    private ScheduledFuture<?> myUploadTask = null;
    private HyperVState myHyperVState = HyperVState.UNKNOWN;
    private EnumSet<CpuInfoFlags> myCpuInfo = EnumSet.noneOf(CpuInfoFlags.class);

    public void start() {
        if (!UsageTracker.getInstance().canTrack()) {
            return;
        }
        this.myUploadTask = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SystemInfoStatsMonitor.this.updateAndUploadStats();
            }
        }, 5L, 360L, TimeUnit.MINUTES);
    }

    private void updateAndUploadStats() {
        if (!UsageTracker.getInstance().canTrack()) {
            this.myUploadTask.cancel(true);
            return;
        }
        if (this.mySdkHandler == null) {
            this.mySdkHandler = AndroidSdkUtils.tryToChooseSdkHandler();
        }
        if (SystemInfo.isWindows) {
            this.updateHyperVState();
        }
        this.updateCpuInfo();
        this.sendStats();
    }

    private void sendStats() {
        String hyperVString = null;
        if (this.myHyperVState != HyperVState.UNKNOWN && this.myHyperVState != HyperVState.ERROR) {
            hyperVString = this.myHyperVState.toString();
        }
        String cpuInfoString = null;
        if (!this.myCpuInfo.contains((Object)CpuInfoFlags.UNKNOWN) && !this.myCpuInfo.contains((Object)CpuInfoFlags.ERROR)) {
            cpuInfoString = Joiner.on((char)',').join(this.myCpuInfo);
        }
        UsageTracker.getInstance().trackSystemInfo(hyperVString, cpuInfoString);
    }

    private void updateHyperVState() {
        if (this.myHyperVState != HyperVState.UNKNOWN && this.myHyperVState != HyperVState.ERROR) {
            return;
        }
        this.myHyperVState = SystemInfoStatsMonitor.calcHyperVState(this.mySdkHandler);
    }

    private void updateCpuInfo() {
        if (!(this.myCpuInfo.isEmpty() || this.myCpuInfo.contains((Object)CpuInfoFlags.ERROR) || this.myCpuInfo.contains((Object)CpuInfoFlags.UNKNOWN))) {
            return;
        }
        this.myCpuInfo = SystemInfoStatsMonitor.calcCpuInfo(this.mySdkHandler);
    }

    @NotNull
    private static File getEmulatorCheckBinary(@NotNull AndroidSdkHandler handler) {
        return new File(handler.getLocation(), FileUtil.join((String[])new String[]{SdkConstants.OS_SDK_TOOLS_FOLDER, SdkConstants.FN_EMULATOR_CHECK}));
    }

    @Nullable
    private static Integer runEmulatorCheck(@NotNull String argument, @NotNull Revision lowestToolsRevisiion, @NotNull AndroidSdkHandler handler) throws ExecutionException {
        LocalPackage toolsPackage = handler.getLocalPackage("tools", (ProgressIndicator)new StudioLoggerProgressIndicator(AndroidSdkInitializer.class));
        if (toolsPackage == null) {
            throw new ExecutionException("No SDK tools package");
        }
        Revision toolsRevision = toolsPackage.getVersion();
        if (toolsRevision.compareTo(lowestToolsRevisiion) < 0) {
            return null;
        }
        File checkBinary = SystemInfoStatsMonitor.getEmulatorCheckBinary(handler);
        if (!checkBinary.isFile()) {
            throw new ExecutionException("No emulator-check binary in the SDK tools package");
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{checkBinary.getPath(), argument});
        CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
        ProcessOutput output = process.runProcess();
        int exitCode = output.getExitCode();
        if (exitCode == 100) {
            throw new ExecutionException(String.format("Emulator-check failed to check for '%s' with a generic error code %d", argument, 100));
        }
        return exitCode;
    }

    @NotNull
    private static HyperVState calcHyperVState(@NotNull AndroidSdkHandler handler) {
        try {
            Integer res = SystemInfoStatsMonitor.runEmulatorCheck("hyper-v", LOWEST_TOOLS_REVISION_HYPERV, handler);
            if (res == null) {
                return HyperVState.UNKNOWN;
            }
            return HyperVState.fromExitCode(res);
        }
        catch (ExecutionException e) {
            LOG.warn("Exception during Hyper-V state calculation", (Throwable)e);
            return HyperVState.ERROR;
        }
    }

    @NotNull
    private static EnumSet<CpuInfoFlags> calcCpuInfo(@NotNull AndroidSdkHandler handler) {
        try {
            Integer res = SystemInfoStatsMonitor.runEmulatorCheck("cpu-info", LOWEST_TOOLS_REVISION_CPU_INFO, handler);
            if (res == null) {
                return EnumSet.of(CpuInfoFlags.UNKNOWN);
            }
            return CpuInfoFlags.fromExitCode(res);
        }
        catch (ExecutionException e) {
            LOG.warn("Exception during CPU information calculation", (Throwable)e);
            return EnumSet.of(CpuInfoFlags.ERROR);
        }
    }

    public static enum CpuInfoFlags {
        ERROR(0),
        AMD(1),
        INTEL(2),
        OTHER_CPU(4),
        IN_VM(8),
        SUPPORTS_VIRT(16),
        UNKNOWN(0x40000000);

        private final int myValue;

        private CpuInfoFlags(int value) {
            this.myValue = value;
        }

        public static EnumSet<CpuInfoFlags> fromExitCode(int code) {
            if (code == 0) {
                return EnumSet.of(ERROR);
            }
            EnumSet<CpuInfoFlags> result = EnumSet.noneOf(CpuInfoFlags.class);
            for (CpuInfoFlags flag : CpuInfoFlags.values()) {
                if (flag == ERROR || (code & flag.myValue) == 0) continue;
                result.add(flag);
                code &= ~flag.myValue;
            }
            if (code != 0) {
                LOG.warn(String.format("CpuInfoFlags.fromExitCode(): unknown flag values '0x%x'", code));
            }
            return result;
        }
    }

    public static enum HyperVState {
        ABSENT,
        INSTALLED,
        RUNNING,
        ERROR,
        UNKNOWN;


        public static HyperVState fromExitCode(int code) {
            switch (code) {
                case 0: {
                    return ABSENT;
                }
                case 1: {
                    return INSTALLED;
                }
                case 2: {
                    return RUNNING;
                }
                case 100: {
                    return ERROR;
                }
            }
            return UNKNOWN;
        }
    }
}

