/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.idea.npw.WizardUtils;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkPaths {
    private SdkPaths() {
    }

    @NotNull
    public static ValidationResult validateAndroidSdk(@Nullable File sdkPath, boolean includePathInMessage) {
        return SdkPaths.validatedSdkPath(sdkPath, "SDK", false, includePathInMessage);
    }

    @NotNull
    public static ValidationResult validateAndroidNdk(@Nullable File ndkPath, boolean includePathInMessage) {
        File toolchainsDirPath;
        WizardUtils.ValidationResult wizardValidationResult;
        if (ndkPath != null && !(wizardValidationResult = WizardUtils.validateLocation(ndkPath.getAbsolutePath(), "Android NDK location", false, WizardUtils.WritableCheckMode.DO_NOT_CHECK)).isOk()) {
            return ValidationResult.error(wizardValidationResult.getFormattedMessage());
        }
        ValidationResult validationResult = SdkPaths.validatedSdkPath(ndkPath, "NDK", false, includePathInMessage);
        if (validationResult.success && ndkPath != null && !(toolchainsDirPath = new File(ndkPath, "toolchains")).isDirectory()) {
            String message = includePathInMessage ? String.format("The NDK at\n'%1$s'\ndoes not contain any toolchains.", ndkPath.getPath()) : "NDK does not contain any toolchains.";
            return ValidationResult.error(message);
        }
        return validationResult;
    }

    @NotNull
    private static ValidationResult validatedSdkPath(@Nullable File sdkPath, @NotNull String sdkName, boolean checkForWritable, boolean includePathInMessage) {
        if (sdkPath == null) {
            return ValidationResult.error("");
        }
        String cause = null;
        if (!sdkPath.isDirectory()) {
            cause = "does not belong to a directory.";
        } else if (!sdkPath.canRead()) {
            cause = "is not readable.";
        } else if (checkForWritable && !sdkPath.canWrite()) {
            cause = "is not writable.";
        }
        if (StringUtil.isNotEmpty((String)cause)) {
            String message = includePathInMessage ? String.format("The path\n'%1$s'\n%2$s", sdkPath.getPath(), cause) : String.format("The path %1$s", cause);
            return ValidationResult.error(message);
        }
        File platformsDirPath = new File(sdkPath, "platforms");
        if (!platformsDirPath.isDirectory()) {
            String message = includePathInMessage ? String.format("The %1$s at\n'%2$s'\ndoes not contain any platforms.", sdkName, sdkPath.getPath()) : String.format("%1$s does not contain any platforms.", sdkName);
            return ValidationResult.error(message);
        }
        return ValidationResult.SUCCESS;
    }

    public static class ValidationResult {
        @NotNull
        public static final ValidationResult SUCCESS = new ValidationResult(true, null);
        public final boolean success;
        @Nullable
        public final String message;

        @NotNull
        static ValidationResult error(@NotNull String message) {
            return new ValidationResult(false, message);
        }

        private ValidationResult(boolean success, @Nullable String message) {
            this.success = success;
            this.message = message;
        }
    }
}

