/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.testing;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.openapi.util.Comparing;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AndroidTestListener
implements ITestRunListener {
    @NotNull
    private final LaunchStatus myLaunchStatus;
    @NotNull
    private final ConsolePrinter myPrinter;
    private long myTestStartingTime;
    private long myTestSuiteStartingTime;
    private String myTestClassName = null;

    public AndroidTestListener(@NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        this.myLaunchStatus = launchStatus;
        this.myPrinter = printer;
    }

    public void testRunStopped(long elapsedTime) {
        this.myLaunchStatus.terminateLaunch("Test run stopped.\n");
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        if (this.myTestClassName != null) {
            this.testSuiteFinished();
        }
        this.myPrinter.stdout("Tests ran to completion.\n");
        this.myLaunchStatus.terminateLaunch("");
    }

    public void testRunFailed(String errorMessage) {
        this.myLaunchStatus.terminateLaunch("Test running failed: " + errorMessage);
    }

    public void testRunStarted(String runName, int testCount) {
        this.myPrinter.stdout("\nStarted running tests\n");
        ServiceMessageBuilder builder = new ServiceMessageBuilder("enteredTheMatrix");
        this.myPrinter.stdout(builder.toString());
    }

    public void testStarted(TestIdentifier test) {
        if (!Comparing.equal((String)test.getClassName(), (String)this.myTestClassName)) {
            if (this.myTestClassName != null) {
                this.testSuiteFinished();
            }
            this.myTestClassName = test.getClassName();
            this.testSuiteStarted();
        }
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testStarted");
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("locationHint", "android://" + test.getClassName() + '.' + test.getTestName() + "()");
        this.myPrinter.stdout(builder.toString());
        this.myTestStartingTime = System.currentTimeMillis();
    }

    private void testSuiteStarted() {
        this.myTestSuiteStartingTime = System.currentTimeMillis();
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testSuiteStarted");
        builder.addAttribute("name", this.myTestClassName);
        builder.addAttribute("locationHint", "android://" + this.myTestClassName);
        this.myPrinter.stdout(builder.toString());
    }

    private void testSuiteFinished() {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testSuiteFinished");
        builder.addAttribute("name", this.myTestClassName);
        builder.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestSuiteStartingTime));
        this.myPrinter.stdout(builder.toString());
        this.myTestClassName = null;
    }

    public void testFailed(TestIdentifier test, String stackTrace) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testFailed");
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("message", "");
        builder.addAttribute("details", stackTrace);
        builder.addAttribute("error", "true");
        this.myPrinter.stdout(builder.toString());
    }

    public void testAssumptionFailure(TestIdentifier test, String trace) {
        ServiceMessageBuilder builder = ServiceMessageBuilder.testIgnored((String)test.getTestName());
        builder.addAttribute("message", "Test ignored. Assumption Failed:");
        builder.addAttribute("details", trace);
        this.myPrinter.stdout(builder.toString());
    }

    public void testIgnored(TestIdentifier test) {
        ServiceMessageBuilder builder = ServiceMessageBuilder.testIgnored((String)test.getTestName());
        this.myPrinter.stdout(builder.toString());
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testFinished");
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestStartingTime));
        this.myPrinter.stdout(builder.toString());
    }
}

