/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class SetFirebaseLogTagsTask
implements LaunchTask {
    @Override
    @NotNull
    public String getDescription() {
        return "Setting Firebase Log Properties on the device";
    }

    @Override
    public int getDuration() {
        return 1;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                NullOutputReceiver receiver = new NullOutputReceiver();
                device.executeShellCommand("setprop log.tag.FA VERBOSE", (IShellOutputReceiver)receiver);
                device.executeShellCommand("setprop log.tag.FA-SVC VERBOSE", (IShellOutputReceiver)receiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return true;
    }

    public static boolean projectUsesFirebase(@NotNull AndroidFacet facet) {
        AndroidGradleModel model = AndroidGradleModel.get(facet);
        if (model == null) {
            return false;
        }
        return GradleUtil.dependsOn(model, "com.google.android.gms:firebase-measurement") || GradleUtil.dependsOn(model, "com.google.firebase:firebase-measurement") || GradleUtil.dependsOn(model, "com.google.firebase:firebase-analytics");
    }
}

