/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.fd.client.InstantRunClient;
import com.android.tools.idea.fd.BuildCause;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkInstaller;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployApkTask
implements LaunchTask {
    private static final Logger LOG = Logger.getInstance(DeployApkTask.class);
    private final Project myProject;
    private final Collection<ApkInfo> myApks;
    private final LaunchOptions myLaunchOptions;
    private final InstantRunContext myInstantRunContext;
    private static int ourInstallationCount = 0;

    public DeployApkTask(@NotNull Project project, @NotNull LaunchOptions launchOptions, @NotNull Collection<ApkInfo> apks) {
        this(project, launchOptions, apks, null);
    }

    public DeployApkTask(@NotNull Project project, @NotNull LaunchOptions launchOptions, @NotNull Collection<ApkInfo> apks, @Nullable InstantRunContext instantRunContext) {
        this.myProject = project;
        this.myLaunchOptions = launchOptions;
        this.myApks = apks;
        this.myInstantRunContext = instantRunContext;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Installing APK";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        ApkInstaller installer = new ApkInstaller(this.myProject, this.myLaunchOptions, (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), printer);
        for (ApkInfo apk : this.myApks) {
            if (!apk.getFile().exists()) {
                String message = "The APK file " + apk.getFile().getPath() + " does not exist on disk.";
                printer.stderr(message);
                LOG.warn(message);
                return false;
            }
            String pkgName = apk.getApplicationId();
            if (!installer.uploadAndInstallApk(device, pkgName, apk.getFile(), launchStatus)) {
                return false;
            }
            if (this.myInstantRunContext != null) continue;
            try {
                InstantRunClient.transferBuildIdToDevice((IDevice)device, (String)"", (String)pkgName, null);
            }
            catch (Throwable throwable) {}
        }
        if (this.myInstantRunContext == null) {
            InstantRunStatsService.get(this.myProject).notifyDeployType(DeployType.LEGACY, BuildCause.NO_INSTANT_RUN, device);
        } else {
            InstantRunStatsService.get(this.myProject).notifyDeployType(DeployType.FULLAPK, this.myInstantRunContext.getBuildSelection().why, device);
        }
        DeployApkTask.trackInstallation(device);
        return true;
    }

    public static void cacheManifestInstallationData(@NotNull IDevice device, @NotNull InstantRunContext context) {
        InstalledPatchCache patchCache = (InstalledPatchCache)ServiceManager.getService(InstalledPatchCache.class);
        patchCache.setInstalledManifestResourcesHash(device, context.getApplicationId(), context.getManifestResourcesHash());
    }

    private static void trackInstallation(@NotNull IDevice device) {
        if (!UsageTracker.getInstance().canTrack()) {
            return;
        }
        if ((ourInstallationCount = (ourInstallationCount + 1) % 20) != 0) {
            return;
        }
        UsageTracker.getInstance().trackEvent("deployment", "apkDeployed", null, null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.serialno.hashed", Hashing.md5().hashString((CharSequence)device.getSerialNumber(), Charsets.UTF_8).toString(), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.tags", device.getProperty("ro.build.tags"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.type", device.getProperty("ro.build.type"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.version.release", device.getProperty("ro.build.version.release"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.version.sdk", device.getProperty("ro.build.version.sdk"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.cpu.abi", device.getProperty("ro.product.cpu.abi"), null);
        String manufacturer = device.getProperty("ro.product.manufacturer");
        String model = device.getProperty("ro.product.model");
        String manufacturerModel = manufacturer + "-" + model;
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.manufacturer", manufacturer, null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.model", model, null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "deviceModel", manufacturerModel, null);
    }
}

