/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.IdDisplay;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.AvdComboBox;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.EmulatorTargetProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorTargetConfigurable
implements DeployTargetConfigurable<EmulatorTargetProvider.State> {
    private final Project myProject;
    private final Disposable myParentDisposable;
    private final DeployTargetConfigurableContext myContext;
    private JPanel myPanel;
    private JBLabel myMinSdkInfoMessageLabel;
    private ComboboxWithBrowseButton myAvdComboWithButton;
    private AvdComboBox myAvdCombo;
    private String myIncorrectPreferredAvd;

    public EmulatorTargetConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        this.myProject = project;
        this.myParentDisposable = parentDisposable;
        this.myContext = context;
        this.$$$setupUI$$$();
        this.myMinSdkInfoMessageLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
        this.myMinSdkInfoMessageLabel.setIcon(AllIcons.General.BalloonWarning);
        context.addModuleChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmulatorTargetConfigurable.this.myAvdCombo.startUpdatingAvds(ModalityState.current());
            }
        });
    }

    private void createUIComponents() {
        this.myAvdCombo = new AvdComboBox(this.myProject, true, false){

            @Override
            public Module getModule() {
                return EmulatorTargetConfigurable.this.myContext.getModule();
            }
        };
        this.myAvdCombo.startUpdatingAvds(ModalityState.current());
        JComboBox avdComboBox = this.myAvdCombo.getComboBox();
        avdComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof IdDisplay) {
                    this.setText(((IdDisplay)value).getDisplay());
                } else {
                    this.setText(String.format("<html><font color='red'>Unknown AVD %1$s</font></html>", value == null ? "" : value.toString()));
                }
            }
        });
        avdComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmulatorTargetConfigurable.this.resetAvdCompatibilityWarningLabel();
            }
        });
        this.myAvdComboWithButton = new ComboboxWithBrowseButton(avdComboBox);
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myAvdCombo);
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    @Override
    public void resetFrom(@NotNull EmulatorTargetProvider.State state, int uniqueID) {
        JComboBox combo = this.myAvdCombo.getComboBox();
        String avd = state.PREFERRED_AVD;
        if (avd != null) {
            Object item = EmulatorTargetConfigurable.findAvdWithName(combo, avd);
            if (item != null) {
                combo.setSelectedItem(item);
            } else {
                combo.setSelectedItem(null);
                this.myIncorrectPreferredAvd = avd;
            }
        }
        this.resetAvdCompatibilityWarningLabel();
    }

    @Override
    public void applyTo(@NotNull EmulatorTargetProvider.State state, int uniqueID) {
        state.PREFERRED_AVD = "";
        JComboBox combo = this.myAvdCombo.getComboBox();
        IdDisplay preferredAvd = (IdDisplay)combo.getSelectedItem();
        state.PREFERRED_AVD = preferredAvd == null ? (this.myIncorrectPreferredAvd != null ? this.myIncorrectPreferredAvd : "") : preferredAvd.getId();
    }

    private void resetAvdCompatibilityWarningLabel() {
        String warning = this.getAvdCompatibilityWarning();
        if (warning != null) {
            this.myMinSdkInfoMessageLabel.setVisible(true);
            this.myMinSdkInfoMessageLabel.setText(warning);
        } else {
            this.myMinSdkInfoMessageLabel.setVisible(false);
        }
    }

    @Nullable
    private String getAvdCompatibilityWarning() {
        IdDisplay selectedItem = (IdDisplay)this.myAvdCombo.getComboBox().getSelectedItem();
        if (selectedItem != null) {
            String selectedAvdName = selectedItem.getId();
            Module module = this.myContext.getModule();
            if (module == null) {
                return null;
            }
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            AvdManager avdManager = facet.getAvdManagerSilently();
            if (avdManager == null) {
                return null;
            }
            AvdInfo avd = avdManager.getAvd(selectedAvdName, false);
            if (avd == null || avd.getSystemImage() == null) {
                return null;
            }
            AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            if (platform == null) {
                return null;
            }
            AndroidVersion minSdk = AndroidModuleInfo.get(facet).getRuntimeMinSdkVersion();
            LaunchCompatibility compatibility = LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), avd.getSystemImage());
            if (compatibility.isCompatible() == ThreeState.NO) {
                return String.format("'%1$s' may be incompatible with your configuration (%2$s)", selectedAvdName, StringUtil.notNullize((String)compatibility.getReason()));
            }
        }
        return null;
    }

    @Nullable
    private static Object findAvdWithName(@NotNull JComboBox avdCombo, @NotNull String avdName) {
        int n = avdCombo.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object item = avdCombo.getItemAt(i);
            if (!(item instanceof IdDisplay) || !avdName.equals(((IdDisplay)item).getId())) continue;
            return item;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Prefer Android Virtual Device:");
        jBLabel2.setDisplayedMnemonic('P');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myAvdComboWithButton;
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, new Dimension(300, -1), null, null));
        this.myMinSdkInfoMessageLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.min.sdk.info.message"));
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 0, null, null, null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

