/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LaunchOptions {
    private final boolean myDeploy;
    private final String myPmInstallOptions;
    private final boolean myDebug;
    private final boolean myOpenLogcatAutomatically;
    private final boolean myClearLogcatBeforeStart;
    private final boolean mySkipNoopApkInstallations;
    private final boolean myForceStopRunningApp;

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    private LaunchOptions(boolean deploy, @Nullable String pmInstallOptions, boolean debug, boolean openLogcatAutomatically, boolean clearLogcatBeforeStart, boolean skipNoopApkInstallations, boolean forceStopRunningApp) {
        this.myDeploy = deploy;
        this.myPmInstallOptions = pmInstallOptions;
        this.myDebug = debug;
        this.myOpenLogcatAutomatically = openLogcatAutomatically;
        this.myClearLogcatBeforeStart = clearLogcatBeforeStart;
        this.mySkipNoopApkInstallations = skipNoopApkInstallations;
        this.myForceStopRunningApp = forceStopRunningApp;
    }

    public boolean isDeploy() {
        return this.myDeploy;
    }

    @Nullable
    public String getPmInstallOptions() {
        return this.myPmInstallOptions;
    }

    public boolean isDebug() {
        return this.myDebug;
    }

    public boolean isOpenLogcatAutomatically() {
        return this.myOpenLogcatAutomatically;
    }

    public boolean isClearLogcatBeforeStart() {
        return this.myClearLogcatBeforeStart;
    }

    public boolean isSkipNoopApkInstallations() {
        return this.mySkipNoopApkInstallations;
    }

    public boolean isForceStopRunningApp() {
        return this.myForceStopRunningApp;
    }

    public static final class Builder {
        private boolean myDeploy = true;
        private String myPmInstallOptions = null;
        private boolean myDebug = false;
        private boolean myOpenLogcatAutomatically = false;
        private boolean myClearLogcatBeforeStart = false;
        private boolean mySkipNoopApkInstallations = true;
        private boolean myForceStopRunningApp = true;

        private Builder() {
        }

        @NotNull
        public LaunchOptions build() {
            return new LaunchOptions(this.myDeploy, this.myPmInstallOptions, this.myDebug, this.myOpenLogcatAutomatically, this.myClearLogcatBeforeStart, this.mySkipNoopApkInstallations, this.myForceStopRunningApp);
        }

        @NotNull
        public Builder setDeploy(boolean deploy) {
            this.myDeploy = deploy;
            return this;
        }

        @NotNull
        public Builder setPmInstallOptions(@Nullable String options) {
            this.myPmInstallOptions = options;
            return this;
        }

        @NotNull
        public Builder setDebug(boolean debug) {
            this.myDebug = debug;
            return this;
        }

        @NotNull
        public Builder setOpenLogcatAutomatically(boolean openLogcatAutomatically) {
            this.myOpenLogcatAutomatically = openLogcatAutomatically;
            return this;
        }

        @NotNull
        public Builder setClearLogcatBeforeStart(boolean clearLogcatBeforeStart) {
            this.myClearLogcatBeforeStart = clearLogcatBeforeStart;
            return this;
        }

        @NotNull
        public Builder setSkipNoopApkInstallations(boolean skipNoopApkInstallations) {
            this.mySkipNoopApkInstallations = skipNoopApkInstallations;
            return this;
        }

        @NotNull
        public Builder setForceStopRunningApp(boolean forceStopRunningApp) {
            this.myForceStopRunningApp = forceStopRunningApp;
            return this;
        }
    }
}

