/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceFutures {
    @NotNull
    private final List<AndroidDevice> myDevices;

    public DeviceFutures(@NotNull List<AndroidDevice> devices) {
        this.myDevices = devices;
    }

    @NotNull
    public List<ListenableFuture<IDevice>> get() {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (AndroidDevice device : this.myDevices) {
            futures.add(device.getLaunchedDevice());
        }
        return futures.build();
    }

    @Nullable
    public List<IDevice> getIfReady() {
        List<ListenableFuture<IDevice>> devices = this.get();
        for (ListenableFuture<IDevice> deviceFuture : devices) {
            if (deviceFuture.isDone() && !deviceFuture.isCancelled()) continue;
            return null;
        }
        try {
            return (List)Futures.get((Future)Futures.allAsList(devices), ExecutionException.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public List<AndroidDevice> getDevices() {
        return this.myDevices;
    }

    @NotNull
    public static DeviceFutures forDevices(@NotNull Iterable<IDevice> devices) {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (IDevice device : devices) {
            futures.add((Object)new ConnectedAndroidDevice(device, null));
        }
        return new DeviceFutures((List<AndroidDevice>)futures.build());
    }
}

