/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.AndroidLogcatUtils;
import com.google.common.base.Strings;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationLogListener
implements AndroidLogcatService.LogLineListener {
    @Nullable
    private LogCatHeader myActiveHeader;
    @NotNull
    private final String myPackageName;
    private final int myPid;

    public ApplicationLogListener(@NotNull String packageName, int pid) {
        this.myPackageName = packageName;
        this.myPid = pid;
    }

    @Override
    public void receiveLogLine(@NotNull LogCatMessage line) {
        String message;
        if (!this.myPackageName.equals(line.getHeader().getAppName()) || this.myPid != line.getHeader().getPid()) {
            this.myActiveHeader = null;
            return;
        }
        if (!line.getHeader().equals(this.myActiveHeader)) {
            this.myActiveHeader = line.getHeader();
            message = this.formatLogLine(line);
        } else {
            message = Strings.repeat((String)" ", (int)this.formatLogLine(line).indexOf(line.getMessage())) + line.getMessage();
        }
        Key key = AndroidLogcatUtils.getProcessOutputType(this.myActiveHeader.getLogLevel());
        this.notifyTextAvailable(message + "\n", key);
    }

    protected abstract String formatLogLine(@NotNull LogCatMessage var1);

    protected abstract void notifyTextAvailable(@NotNull String var1, @NotNull Key var2);
}

