/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.ApkProvisionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkProviderUtil {
    private static final Logger LOG = Logger.getInstance(ApkProviderUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String computePackageName(@NotNull AndroidFacet facet) throws ApkProvisionException {
        if (facet.getProperties().USE_CUSTOM_MANIFEST_PACKAGE) {
            return facet.getProperties().CUSTOM_MANIFEST_PACKAGE;
        }
        if (facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST) {
            LocalFileSystem.getInstance().refresh(false);
            File manifestCopy = null;
            try {
                Manifest manifest;
                VirtualFile manifestVFile;
                Pair<File, String> pair;
                try {
                    pair = ApkProviderUtil.getCopyOfCompilerManifestFile(facet);
                }
                catch (IOException e) {
                    throw new ApkProvisionException("Could not compute package name because of I/O error: " + e.getMessage(), e);
                }
                manifestCopy = pair != null ? (File)pair.getFirst() : null;
                VirtualFile virtualFile = manifestVFile = manifestCopy != null ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(manifestCopy) : null;
                if (manifestVFile != null) {
                    manifestVFile.refresh(false, false);
                    manifest = AndroidUtils.loadDomElement(facet.getModule(), manifestVFile, Manifest.class);
                } else {
                    manifest = null;
                }
                final String manifestLocalPath = pair != null ? (String)pair.getSecond() : null;
                Module module = facet.getModule();
                final String moduleName = module.getName();
                if (manifest == null) {
                    throw new ApkProvisionException("Cannot find AndroidManifest.xml file for module " + moduleName);
                }
                String string = (String)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<String, ApkProvisionException>(){

                    public String compute() throws ApkProvisionException {
                        GenericAttributeValue<String> packageAttrValue = manifest.getPackage();
                        String aPackage = (String)packageAttrValue.getValue();
                        if (aPackage == null || aPackage.isEmpty()) {
                            throw new ApkProvisionException("[" + moduleName + "] Main package is not specified in file " + manifestLocalPath);
                        }
                        return aPackage;
                    }
                });
                return string;
            }
            finally {
                if (manifestCopy != null) {
                    FileUtil.delete((File)manifestCopy.getParentFile());
                }
            }
        }
        String pkg = AndroidModuleInfo.get(facet).getPackage();
        if (pkg == null || pkg.isEmpty()) {
            throw new ApkProvisionException("[" + facet.getModule().getName() + "] Unable to obtain main package from manifest.");
        }
        return pkg;
    }

    @Nullable
    public static Pair<File, String> getCopyOfCompilerManifestFile(@NotNull AndroidFacet facet) throws IOException {
        VirtualFile manifestFile = AndroidRootUtil.getCustomManifestFileForCompiler(facet);
        if (manifestFile == null) {
            return null;
        }
        File tmpDir = null;
        try {
            tmpDir = FileUtil.createTempDirectory((String)"android_manifest_file_for_execution", (String)"tmp");
            File manifestCopy = new File(tmpDir, manifestFile.getName());
            FileUtil.copy((File)new File(manifestFile.getPath()), (File)manifestCopy);
            return Pair.create((Object)manifestCopy, (Object)PathUtil.getLocalPath((VirtualFile)manifestFile));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            if (tmpDir != null) {
                FileUtil.delete((File)tmpDir);
            }
            throw e;
        }
    }
}

