/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.testing.AndroidTestRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import org.jetbrains.annotations.NotNull;

public class AndroidProgramRunner
extends DefaultProgramRunner {
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        RunContentDescriptor descriptor;
        boolean showRunContent = env.getRunProfile() instanceof AndroidTestRunConfiguration;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
        if (runnerAndConfigurationSettings != null) {
            runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(showRunContent);
        }
        if ((descriptor = super.doExecute(state, env)) != null) {
            ProcessHandler processHandler = descriptor.getProcessHandler();
            assert (processHandler != null);
            RunProfile runProfile = env.getRunProfile();
            int uniqueId = runProfile instanceof AndroidRunConfigurationBase ? ((AndroidRunConfigurationBase)runProfile).getUniqueID() : -1;
            AndroidSessionInfo sessionInfo = new AndroidSessionInfo(processHandler, descriptor, uniqueId, env.getExecutor().getId(), InstantRunUtils.isInstantRunEnabled(env));
            processHandler.putUserData(AndroidSessionInfo.KEY, (Object)sessionInfo);
        }
        return descriptor;
    }

    @NotNull
    public String getRunnerId() {
        return "AndroidProgramRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (!DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && !DefaultRunExecutor.EXECUTOR_ID.equals(executorId)) {
            return false;
        }
        return profile instanceof AndroidRunConfigurationBase;
    }
}

