/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCache;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResourceFolderRepositoryFileCacheImpl
implements ResourceFolderRepositoryFileCache {
    private static final String CACHE_DIRECTORY = "resource_folder_cache";
    private static final String INVALIDATE_CACHE_STAMP = "invalidate_caches_stamp.dat";
    static final int EXPECTED_CACHE_VERSION = 1;
    private static final String CACHE_VERSION_FILENAME = "cache_version";
    private Integer myCacheVersion = null;
    private final File myRootDir;

    public ResourceFolderRepositoryFileCacheImpl() {
        this.myRootDir = new File(PathManager.getSystemPath(), CACHE_DIRECTORY);
    }

    public ResourceFolderRepositoryFileCacheImpl(File rootDirParent) {
        this.myRootDir = new File(rootDirParent, CACHE_DIRECTORY);
    }

    private static Logger getLogger() {
        return Logger.getInstance(ResourceFolderRepositoryFileCacheImpl.class);
    }

    @Override
    @Nullable
    public File getResourceDir(@NotNull Project project, @NotNull VirtualFile resourceDir) {
        if (!this.isValid()) {
            return null;
        }
        File projectComponent = this.getProjectDir(project);
        if (projectComponent == null) {
            return null;
        }
        String dirComponent = FileUtil.sanitizeFileName((String)(resourceDir.getParent().getName() + "_" + Integer.toHexString(resourceDir.hashCode())));
        return new File(projectComponent, dirComponent);
    }

    @Override
    @Nullable
    public File getRootDir() {
        File cacheRootDir = this.myRootDir;
        if (!cacheRootDir.exists()) {
            if (!cacheRootDir.mkdirs()) {
                ResourceFolderRepositoryFileCacheImpl.getLogger().error(String.format("Failed to create cache root directory %1$s", cacheRootDir));
                return null;
            }
            this.stampVersion(cacheRootDir, 1);
        }
        if (!cacheRootDir.isDirectory()) {
            ResourceFolderRepositoryFileCacheImpl.getLogger().error(String.format("Cache root dir %1$s is not a directory", cacheRootDir));
            return null;
        }
        return cacheRootDir;
    }

    @Override
    @Nullable
    public File getProjectDir(@NotNull Project project) {
        File rootDir = this.getRootDir();
        if (rootDir == null) {
            return null;
        }
        String projectComponent = FileUtil.sanitizeFileName((String)(project.getName() + "_" + project.getLocationHash()));
        return new File(rootDir, projectComponent);
    }

    @Override
    public void invalidate() {
        if (!this.isValid()) {
            return;
        }
        File rootDir = this.getRootDir();
        if (rootDir == null) {
            return;
        }
        File stamp = new File(rootDir, INVALIDATE_CACHE_STAMP);
        String errMsg = "failed to write cache invalidating stamp file " + stamp;
        try {
            if (!stamp.createNewFile()) {
                ResourceFolderRepositoryFileCacheImpl.getLogger().error(errMsg);
            }
        }
        catch (IOException e) {
            ResourceFolderRepositoryFileCacheImpl.getLogger().error(errMsg, (Throwable)e);
        }
    }

    @Override
    public void delete() {
        File cacheRootDir = this.getRootDir();
        if (cacheRootDir == null) {
            return;
        }
        File[] subCaches = cacheRootDir.listFiles();
        if (subCaches == null) {
            return;
        }
        File stamp = new File(cacheRootDir, INVALIDATE_CACHE_STAMP);
        for (File subCache : subCaches) {
            if (FileUtil.filesEqual((File)stamp, (File)subCache)) continue;
            FileUtil.delete((File)subCache);
        }
        FileUtil.delete((File)cacheRootDir);
        this.myCacheVersion = null;
    }

    @Override
    public boolean isValid() {
        File rootDir = this.getRootDir();
        if (rootDir == null) {
            return false;
        }
        if (!this.isVersionSame(rootDir)) {
            return false;
        }
        File stamp = new File(rootDir, INVALIDATE_CACHE_STAMP);
        return !stamp.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVersionSame(@NotNull File rootDir) {
        if (this.myCacheVersion != null) {
            return this.myCacheVersion == 1;
        }
        File versionFile = new File(rootDir, CACHE_VERSION_FILENAME);
        if (!versionFile.exists()) {
            return false;
        }
        try (DataInputStream in = new DataInputStream(new FileInputStream(versionFile));){
            this.myCacheVersion = in.readInt();
        }
        catch (FileNotFoundException e) {
            ResourceFolderRepositoryFileCacheImpl.getLogger().error("Could not read cache version from file: " + versionFile, (Throwable)e);
            return false;
        }
        catch (IOException e) {
            ResourceFolderRepositoryFileCacheImpl.getLogger().error("Could not read cache version from file: " + versionFile, (Throwable)e);
            return false;
        }
        return this.myCacheVersion == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stampVersion(@NotNull File rootDir, int version) {
        File versionFile = new File(rootDir, CACHE_VERSION_FILENAME);
        try {
            FileUtil.ensureExists((File)rootDir);
            try (DataOutputStream out = new DataOutputStream(new FileOutputStream(versionFile));){
                out.writeInt(version);
                this.myCacheVersion = version;
            }
        }
        catch (FileNotFoundException e) {
            ResourceFolderRepositoryFileCacheImpl.getLogger().error("Could not write cache version to file: " + versionFile, (Throwable)e);
        }
        catch (IOException e) {
            ResourceFolderRepositoryFileCacheImpl.getLogger().error("Could not write cache version to file: " + versionFile, (Throwable)e);
        }
    }

    public static class PopulateCachesActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            DumbService dumbService = DumbService.getInstance((Project)project);
            ResourceFolderRegistry.PopulateCachesTask task = new ResourceFolderRegistry.PopulateCachesTask(project);
            dumbService.queueTask((DumbModeTask)task);
        }
    }

    public static class MaintenanceActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            DumbService dumbService = DumbService.getInstance((Project)project);
            PruneTask pruneTask = new PruneTask(project);
            dumbService.queueTask((DumbModeTask)pruneTask);
            ManageLruProjectFilesTask manageProjectsTask = new ManageLruProjectFilesTask(project);
            dumbService.queueTask((DumbModeTask)manageProjectsTask);
        }
    }

    public static class CacheInvalidator
    extends CachesInvalidator {
        public void invalidateCaches() {
            ResourceFolderRepositoryFileCacheService.get().invalidate();
        }
    }

    static class PruneTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        public PruneTask(@NotNull Project project) {
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            ResourceFolderRepositoryFileCache cache = ResourceFolderRepositoryFileCacheService.get();
            File projectCacheBase = cache.getProjectDir(this.myProject);
            if (projectCacheBase == null || !projectCacheBase.exists()) {
                return;
            }
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            Map<VirtualFile, AndroidFacet> resDirectories = ResourceFolderRegistry.getResourceDirectoriesForFacets(facets);
            HashSet usedCacheDirectories = Sets.newHashSet();
            for (VirtualFile resourceDir : resDirectories.keySet()) {
                File dir = cache.getResourceDir(this.myProject, resourceDir);
                ContainerUtil.addIfNotNull((Collection)usedCacheDirectories, (Object)dir);
            }
            File[] cacheFiles = projectCacheBase.listFiles();
            if (cacheFiles == null) {
                ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to prune cache files from " + projectCacheBase);
                return;
            }
            for (File child : cacheFiles) {
                if (usedCacheDirectories.contains(child) || FileUtil.delete((File)child)) continue;
                ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to prune child " + child);
            }
        }
    }

    static class ManageLruProjectFilesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;
        private static final Object PROJECT_LRU_LOCK = new Object();
        private static final String LRU_FILE = "project_lru_list.dat";
        private static final int MAX_PROJECT_CACHES = 12;

        public ManageLruProjectFilesTask(@NotNull Project project) {
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            this.maintainLRUCache(12);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maintainLRUCache(int maxProjectCaches) {
            assert (maxProjectCaches > 0);
            ResourceFolderRepositoryFileCache cache = ResourceFolderRepositoryFileCacheService.get();
            File cacheRootDir = cache.getRootDir();
            if (cacheRootDir == null) {
                return;
            }
            if (!cache.isValid()) {
                cache.delete();
                return;
            }
            Object object = PROJECT_LRU_LOCK;
            synchronized (object) {
                try {
                    List<File> projectsList = ManageLruProjectFilesTask.loadListOfProjectCaches(cacheRootDir);
                    List<File> projectsToRemove = ManageLruProjectFilesTask.updateLRUList(this.myProject, projectsList, maxProjectCaches);
                    ManageLruProjectFilesTask.pruneOldProjects(cacheRootDir, projectsToRemove);
                    ManageLruProjectFilesTask.writeListOfProjectCaches(cacheRootDir, projectsList);
                }
                catch (IOException e) {
                    ResourceFolderRepositoryFileCacheImpl.getLogger().error("Failed to maintain projects LRU cache for dir " + cacheRootDir, (Throwable)e);
                }
            }
        }

        /*
         * Exception decompiling
         */
        static List<File> loadListOfProjectCaches(@NotNull File cacheRootDir) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void writeListOfProjectCaches(@NotNull File cacheRootDir, List<File> projectsList) throws IOException {
            File lruFile = new File(cacheRootDir, LRU_FILE);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(lruFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                try {
                    oos.writeObject(projectsList);
                }
                finally {
                    Closeables.close((Closeable)oos, (boolean)false);
                }
            }
            finally {
                Closeables.close((Closeable)fos, (boolean)false);
            }
        }

        static List<File> updateLRUList(Project currentProject, List<File> projectsList, int maxProjectCaches) {
            ArrayList projectsToRemove = ContainerUtil.newArrayList();
            File currentProjectDir = ResourceFolderRepositoryFileCacheService.get().getProjectDir(currentProject);
            if (currentProjectDir == null) {
                return projectsToRemove;
            }
            projectsList.remove(currentProjectDir);
            projectsList.add(0, currentProjectDir);
            for (int i = projectsList.size() - 1; i >= maxProjectCaches && i >= 0; --i) {
                projectsToRemove.add(projectsList.remove(i));
            }
            return projectsToRemove;
        }

        private static void pruneOldProjects(@NotNull File cacheRootDir, List<File> projectsToRemove) {
            File[] subCaches = cacheRootDir.listFiles();
            if (subCaches == null) {
                ResourceFolderRepositoryFileCacheImpl.getLogger().error(String.format("Cache root %1$s is not a directory", cacheRootDir));
                return;
            }
            List<File> subCacheList = Arrays.asList(subCaches);
            for (File projectDir : projectsToRemove) {
                if (!subCacheList.contains(projectDir) || FileUtil.delete((File)projectDir)) continue;
                ResourceFolderRepositoryFileCacheImpl.getLogger().error(String.format("Failed to prune dir %1$s", projectDir));
            }
        }
    }
}

