/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import java.util.Map;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class PsiProjectListener
extends AbstractProjectComponent
implements PsiTreeChangeListener {
    @NotNull
    private final Map<VirtualFile, ResourceFolderRepository> myListeners = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRoot(@NotNull Project project, @NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        Class<PsiProjectListener> clazz = PsiProjectListener.class;
        synchronized (PsiProjectListener.class) {
            PsiProjectListener.getInstance(project).addRoot(root, repository);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRoot(@NotNull Project project, @NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        Class<PsiProjectListener> clazz = PsiProjectListener.class;
        synchronized (PsiProjectListener.class) {
            PsiProjectListener.getInstance(project).removeRoot(root, repository);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @NotNull
    public static PsiProjectListener getInstance(@NotNull Project project) {
        return (PsiProjectListener)((Object)project.getComponent(PsiProjectListener.class));
    }

    public PsiProjectListener(@NotNull Project project) {
        super(project);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)this);
    }

    private void addRoot(@NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        assert (this.myListeners.get(root) == null);
        this.myListeners.put(root, repository);
    }

    private void removeRoot(@NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        assert (this.myListeners.get(root) == repository) : repository;
        this.myListeners.remove(root);
    }

    static boolean isRelevantFileType(@NotNull FileType fileType) {
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        return fileType == StdFileTypes.XML || fileType.isBinary() && fileType == ImageFileTypeManager.getInstance().getImageFileType();
    }

    static boolean isRelevantFile(@NotNull VirtualFile file) {
        String parentName;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    static boolean isRelevantFile(@NotNull PsiFile file) {
        String parentName;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        PsiDirectory parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    @Nullable
    private ResourceFolderRepository findRepository(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        while (file != null) {
            ResourceFolderRepository repository = this.myListeners.get(file);
            if (repository != null) {
                return repository;
            }
            file = file.getParent();
        }
        return null;
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildAdded(event, file);
                }
            } else if (child instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)child;
                this.dispatchChildAdded(event, directory.getVirtualFile());
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            this.dispatchChildAdded(event, psiFile.getVirtualFile());
        } else if (PsiProjectListener.isGradleFileEdit(psiFile)) {
            PsiProjectListener.notifyGradleEdit(psiFile);
        }
    }

    private void dispatchChildAdded(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childAdded(event);
        }
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            PsiDirectory directory;
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildRemoved(event, file);
                }
            } else if (child instanceof PsiDirectory && ResourceFolderType.getFolderType((String)(directory = (PsiDirectory)child).getName()) != null) {
                VirtualFile file = directory.getVirtualFile();
                this.dispatchChildRemoved(event, file);
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchChildRemoved(event, file);
        } else if (PsiProjectListener.isGradleFileEdit(psiFile)) {
            PsiProjectListener.notifyGradleEdit(psiFile);
        }
    }

    private void dispatchChildRemoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childRemoved(event);
        }
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile != null) {
            if (PsiProjectListener.isRelevantFile(psiFile)) {
                this.dispatchChildReplaced(event, psiFile.getVirtualFile());
            } else if (PsiProjectListener.isGradleFileEdit(psiFile)) {
                PsiProjectListener.notifyGradleEdit(psiFile);
            }
        } else {
            PsiElement parent = event.getParent();
            if (parent instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)parent;
                this.dispatchChildReplaced(event, directory.getVirtualFile());
            }
        }
    }

    private void dispatchChildReplaced(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childReplaced(event);
        }
    }

    private static boolean isGradleFileEdit(@NotNull PsiFile psiFile) {
        VirtualFile virtualFile;
        return psiFile.getFileType() == GroovyFileType.GROOVY_FILE_TYPE && (virtualFile = psiFile.getVirtualFile()) != null && "gradle".equals(virtualFile.getExtension());
    }

    private static void notifyGradleEdit(@NotNull PsiFile psiFile) {
        EditorNotifications.getInstance((Project)psiFile.getProject()).updateAllNotifications();
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile != null && PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchChildrenChanged(event, file);
        }
    }

    private void dispatchChildrenChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childrenChanged(event);
        }
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        PsiElement child = event.getChild();
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            if (child instanceof PsiFile && PsiProjectListener.isRelevantFile((PsiFile)child)) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null) {
                    this.dispatchChildMoved(event, file);
                    return;
                }
                PsiElement oldParent = event.getOldParent();
                if (oldParent instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)oldParent;
                    VirtualFile dir = directory.getVirtualFile();
                    this.dispatchChildMoved(event, dir);
                }
            }
        } else {
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null && PsiProjectListener.isRelevantFile(file)) {
                this.dispatchChildMoved(event, file);
            }
        }
    }

    private void dispatchChildMoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        PsiDirectory sourceDir;
        ResourceFolderRepository targetRepository;
        PsiElement oldParent;
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childMoved(event);
        }
        if (event.getFile() == null && (oldParent = event.getOldParent()) instanceof PsiDirectory && (targetRepository = this.findRepository((sourceDir = (PsiDirectory)oldParent).getVirtualFile())) != null && targetRepository != repository) {
            targetRepository.getPsiListener().childMoved(event);
        }
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if ("fileName" == event.getPropertyName() && (child = event.getChild()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchBeforePropertyChange(event, file);
        }
    }

    private void dispatchBeforePropertyChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().beforePropertyChange(event);
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if ("fileName" == event.getPropertyName() && (child = event.getElement()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchPropertyChange(event, file);
        }
    }

    private void dispatchPropertyChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().propertyChanged(event);
        }
    }
}

