/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.DynamicResourceValueRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;
    private final ResourceFolderManager.ResourceFolderListener myResourceFolderListener = new ResourceFolderManager.ResourceFolderListener(){

        @Override
        public void resourceFoldersChanged(@NotNull AndroidFacet facet, @NotNull List<VirtualFile> folders, @NotNull Collection<VirtualFile> added, @NotNull Collection<VirtualFile> removed) {
            ModuleResourceRepository.this.updateRoots();
        }
    };

    private ModuleResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates) {
        super(facet.getModule().getName(), delegates);
        this.myFacet = facet;
        this.myFacet.getResourceFolderManager().addListener(this.myResourceFolderListener);
    }

    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull Module module, boolean createIfNecessary) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            return facet.getModuleResources(createIfNecessary);
        }
        return null;
    }

    @Contract(value="!null, true -> !null")
    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        return facet.getModuleResources(createIfNecessary);
    }

    @NotNull
    public static LocalResourceRepository create(@NotNull AndroidFacet facet) {
        boolean gradleProject = facet.requiresAndroidModel();
        if (!gradleProject) {
            VirtualFile primaryResourceDir = facet.getPrimaryResourceDir();
            if (primaryResourceDir == null) {
                return new EmptyRepository();
            }
            return ResourceFolderRegistry.get(facet, primaryResourceDir);
        }
        ResourceFolderManager folderManager = facet.getResourceFolderManager();
        List<VirtualFile> resourceDirectories = folderManager.getFolders();
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)resourceDirectories.size());
        for (VirtualFile resourceDirectory : resourceDirectories) {
            ResourceFolderRepository repository = ResourceFolderRegistry.get(facet, resourceDirectory);
            resources.add(repository);
        }
        DynamicResourceValueRepository dynamicResources = DynamicResourceValueRepository.create(facet);
        resources.add(dynamicResources);
        ModuleResourceRepository repository = new ModuleResourceRepository(facet, (List<? extends LocalResourceRepository>)resources);
        Disposer.register((Disposable)repository, (Disposable)dynamicResources);
        return repository;
    }

    private void updateRoots() {
        this.updateRoots(this.myFacet.getResourceFolderManager().getFolders());
    }

    void updateRoots(List<VirtualFile> resourceDirectories) {
        List other = null;
        HashMap map = Maps.newHashMap();
        for (LocalResourceRepository repository : this.myChildren) {
            if (repository instanceof ResourceFolderRepository) {
                ResourceFolderRepository folderRepository = (ResourceFolderRepository)repository;
                VirtualFile resourceDir = folderRepository.getResourceDir();
                map.put(resourceDir, folderRepository);
                continue;
            }
            assert (repository instanceof DynamicResourceValueRepository);
            if (other == null) {
                other = Lists.newArrayList();
            }
            other.add(repository);
        }
        HashSet newDirs = Sets.newHashSet(resourceDirectories);
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)(newDirs.size() + (other != null ? other.size() : 0)));
        for (VirtualFile dir : resourceDirectories) {
            ResourceFolderRepository repository = (ResourceFolderRepository)((Object)map.get(dir));
            if (repository == null) {
                repository = ResourceFolderRegistry.get(this.myFacet, dir);
            } else {
                map.remove(dir);
            }
            resources.add(repository);
        }
        if (other != null) {
            resources.addAll(other);
        }
        if (resources.equals(this.myChildren)) {
            assert (map.isEmpty());
            return;
        }
        for (ResourceFolderRepository removed : map.values()) {
            removed.removeParent(this);
        }
        this.setChildren(resources);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myFacet.getResourceFolderManager().removeListener(this.myResourceFolderListener);
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories) {
        return ModuleResourceRepository.createForTest(facet, resourceDirectories, Collections.emptyList());
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories, @NotNull Collection<LocalResourceRepository> otherDelegates) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ArrayList<LocalResourceRepository> delegates = new ArrayList<LocalResourceRepository>(resourceDirectories.size() + otherDelegates.size());
        for (VirtualFile resourceDirectory : resourceDirectories) {
            delegates.add(ResourceFolderRegistry.get(facet, resourceDirectory));
        }
        delegates.addAll(otherDelegates);
        return new ModuleResourceRepository(facet, delegates);
    }

    private static class EmptyRepository
    extends MultiResourceRepository {
        public EmptyRepository() {
            super("", Collections.emptyList());
        }

        @Override
        protected void setChildren(@NotNull List<? extends LocalResourceRepository> children) {
            this.myChildren = children;
        }
    }
}

