/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.DuplicateDataException;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourceSet;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.RDotTxtParser;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SoftValueHashMap;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileResourceRepository
extends LocalResourceRepository {
    private static final Logger LOG = Logger.getInstance(FileResourceRepository.class);
    protected final Map<ResourceType, ListMultimap<String, ResourceItem>> myItems = Maps.newEnumMap(ResourceType.class);
    protected Collection<String> myAarDeclaredIds;
    private final File myFile;
    @Nullable
    private File myResourceTextFile;
    private static final SoftValueHashMap<File, FileResourceRepository> ourCache = new SoftValueHashMap();

    private FileResourceRepository(@NotNull File file) {
        super(file.getName());
        this.myFile = file;
    }

    @NotNull
    static FileResourceRepository get(@NotNull File file, @Nullable String libraryName) {
        FileResourceRepository repository = (FileResourceRepository)((Object)ourCache.get((Object)file));
        if (repository == null) {
            repository = FileResourceRepository.create(file, libraryName);
            ourCache.put((Object)file, (Object)repository);
        }
        return repository;
    }

    @Nullable
    static FileResourceRepository getCached(@NotNull File file) {
        return (FileResourceRepository)((Object)ourCache.get((Object)file));
    }

    @NotNull
    private static FileResourceRepository create(@NotNull File file, @Nullable String libraryName) {
        File rDotTxt;
        FileResourceRepository repository = new FileResourceRepository(file);
        try {
            ResourceMerger resourceMerger = FileResourceRepository.createResourceMerger(file, libraryName);
            resourceMerger.mergeData(repository.createMergeConsumer(), true);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize resources", (Throwable)e);
        }
        if (file.getPath().contains("exploded-aar") && (rDotTxt = new File(file.getParentFile(), "R.txt")).exists()) {
            repository.myResourceTextFile = rDotTxt;
            repository.myAarDeclaredIds = RDotTxtParser.getIdNames(rDotTxt);
        }
        return repository;
    }

    @Nullable
    File getResourceTextFile() {
        return this.myResourceTextFile;
    }

    public static void reset() {
        ourCache.clear();
    }

    public File getResourceDirectory() {
        return this.myFile;
    }

    private static ResourceMerger createResourceMerger(File file, String libraryName) {
        LogWrapper logger = new LogWrapper(LOG);
        ResourceMerger merger = new ResourceMerger(0);
        ResourceSet resourceSet = new ResourceSet(file.getName(), libraryName, false);
        resourceSet.addSource(file);
        resourceSet.setTrackSourcePositions(false);
        try {
            resourceSet.loadFromFiles((ILogger)logger);
        }
        catch (DuplicateDataException e) {
            assert (false);
        }
        catch (MergingException e) {
            LOG.warn((Throwable)e);
        }
        merger.addDataSet(resourceSet);
        return merger;
    }

    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        return this.myItems;
    }

    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        ArrayListMultimap multimap = this.myItems.get(type);
        if (multimap == null && create) {
            multimap = ArrayListMultimap.create();
            this.myItems.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        return multimap;
    }

    @Nullable
    protected Collection<String> getAllDeclaredIds() {
        return this.myAarDeclaredIds;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for " + this.myFile + ": @" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.myFile, (!ApplicationManager.getApplication().isReadAccessAllowed() ? 1 : 0) != 0);
        if (virtualFile == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.of((Object)virtualFile);
    }
}

