/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.AssetRepository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetRepositoryImpl
extends AssetRepository
implements Disposable {
    private AndroidFacet myFacet;

    public AssetRepositoryImpl(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
        Disposer.register((Disposable)this.myFacet, (Disposable)this);
    }

    public boolean isSupported() {
        return true;
    }

    @Nullable
    public InputStream openAsset(String path, int mode) throws IOException {
        assert (this.myFacet != null);
        List<IdeaSourceProvider> sourceProviders = IdeaSourceProvider.getAllIdeaSourceProviders(this.myFacet);
        for (int i = sourceProviders.size() - 1; i >= 0; --i) {
            for (VirtualFile assetDir : sourceProviders.get(i).getAssetsDirectories()) {
                VirtualFile asset = assetDir.findFileByRelativePath(path);
                if (asset == null) continue;
                return asset.getInputStream();
            }
        }
        return null;
    }

    public void dispose() {
        this.myFacet = null;
    }
}

