/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.IntArrayWrapper;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.res.AarResourceClassRegistry;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.android.tools.idea.res.RDotTxtParser;
import com.android.util.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;
    private List<FileResourceRepository> myLibraries;
    private long myIdsModificationCount;
    private final LinkedList<FileResourceRepository> myAarLibraries = Lists.newLinkedList();
    private Set<String> myIds;
    private ResourceVisibilityLookup myResourceVisibility;
    private ResourceVisibilityLookup.Provider myResourceVisibilityProvider;
    private static final int DYNAMIC_ID_SEED_START = 0x7FFF0000;
    private Map<ResourceType, TObjectIntHashMap<String>> myResourceValueMap;
    private TIntObjectHashMap<Pair<ResourceType, String>> myResIdValueToNameMap;
    private Map<IntArrayWrapper, String> myStyleableValueToNameMap;
    private final TObjectIntHashMap<TypedResourceName> myName2DynamicIdMap = new TObjectIntHashMap();
    private final TIntObjectHashMap<TypedResourceName> myDynamicId2ResourceMap = new TIntObjectHashMap();
    private int myDynamicSeed = 0x7FFF0000;
    private final IntArrayWrapper myWrapper = new IntArrayWrapper(null);

    protected AppResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates, @NotNull List<FileResourceRepository> libraries) {
        super(facet.getModule().getName() + " with modules and libraries", delegates);
        this.myFacet = facet;
        this.myLibraries = libraries;
        for (FileResourceRepository library : libraries) {
            if (library.getResourceTextFile() == null) continue;
            this.myAarLibraries.add(library);
        }
    }

    @Nullable
    public static AppResourceRepository getAppResources(@NotNull Module module, boolean createIfNecessary) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            return facet.getAppResources(createIfNecessary);
        }
        return null;
    }

    @Contract(value="!null, true -> !null")
    @Nullable
    public static AppResourceRepository getAppResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        return facet.getAppResources(createIfNecessary);
    }

    @NotNull
    public static AppResourceRepository create(@NotNull AndroidFacet facet) {
        List<FileResourceRepository> libraries = AppResourceRepository.computeLibraries(facet);
        List<LocalResourceRepository> delegates = AppResourceRepository.computeRepositories(facet, libraries);
        AppResourceRepository repository = new AppResourceRepository(facet, delegates, libraries);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        return repository;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet, List<FileResourceRepository> libraries) {
        ArrayList repositories = Lists.newArrayListWithExpectedSize((int)10);
        ProjectResourceRepository resources = ProjectResourceRepository.getProjectResources(facet, true);
        repositories.addAll(libraries);
        repositories.add(resources);
        return repositories;
    }

    private static List<FileResourceRepository> computeLibraries(@NotNull AndroidFacet facet) {
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        Map<File, String> aarDirs = AppResourceRepository.findAarLibraries(facet, dependentFacets);
        if (aarDirs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList dirs = Lists.newArrayList(aarDirs.keySet());
        Collections.sort(dirs);
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)aarDirs.size());
        for (File root : dirs) {
            resources.add(FileResourceRepository.get(root, aarDirs.get(root)));
        }
        return resources;
    }

    @NotNull
    private static Map<File, String> findAarLibraries(@NotNull AndroidFacet facet, @NotNull List<AndroidFacet> dependentFacets) {
        AndroidGradleModel androidGradleModel = AndroidGradleModel.get(facet);
        if (androidGradleModel != null) {
            ArrayList libraries = Lists.newArrayList();
            AppResourceRepository.addGradleLibraries(libraries, androidGradleModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidGradleModel dependentGradleModel = AndroidGradleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                AppResourceRepository.addGradleLibraries(libraries, dependentGradleModel);
            }
            return AppResourceRepository.findAarLibrariesFromGradle(androidGradleModel.getModelVersion(), dependentFacets, libraries);
        }
        return AppResourceRepository.findAarLibrariesFromIntelliJ(facet, dependentFacets);
    }

    @NotNull
    public static Collection<AndroidLibrary> findAarLibraries(@NotNull AndroidFacet facet) {
        AndroidGradleModel androidModel;
        ArrayList libraries = Lists.newArrayList();
        if (facet.requiresAndroidModel() && (androidModel = AndroidGradleModel.get(facet)) != null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
            AppResourceRepository.addGradleLibraries(libraries, androidModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidGradleModel dependentGradleModel = AndroidGradleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                AppResourceRepository.addGradleLibraries(libraries, dependentGradleModel);
            }
        }
        return libraries;
    }

    private static Map<File, String> findAarLibrariesFromIntelliJ(AndroidFacet facet, List<AndroidFacet> dependentFacets) {
        HashMap<File, String> dirs = new HashMap<File, String>();
        ResourceFolderManager.addAarsFromModuleLibraries(facet, dirs);
        for (AndroidFacet f : dependentFacets) {
            ResourceFolderManager.addAarsFromModuleLibraries(f, dirs);
        }
        return dirs;
    }

    @NotNull
    private static Map<File, String> findAarLibrariesFromGradle(@NotNull GradleVersion modelVersion, List<AndroidFacet> dependentFacets, List<AndroidLibrary> libraries) {
        HashMap<File, String> files = new HashMap<File, String>(libraries.size());
        HashSet moduleNames = Sets.newHashSet();
        for (AndroidFacet f : dependentFacets) {
            moduleNames.add(f.getModule().getName());
        }
        try {
            for (AndroidLibrary library : libraries) {
                File resFolder;
                String libraryName = null;
                String projectName = library.getProject();
                if (projectName != null && !projectName.isEmpty()) {
                    libraryName = projectName.substring(projectName.lastIndexOf(58) + 1);
                    moduleNames.add(libraryName);
                    continue;
                }
                File folder = library.getFolder();
                String name = folder.getName();
                if (name.endsWith(".aar")) {
                    libraryName = name.substring(0, name.length() - ".aar".length());
                } else if (folder.getPath().contains("exploded-aar")) {
                    libraryName = folder.getParentFile().getName();
                }
                if (libraryName == null || moduleNames.contains(libraryName) || !(resFolder = library.getResFolder()).exists()) continue;
                name = libraryName;
                if (modelVersion.getMajor() > 2 || modelVersion.getMajor() == 2 && modelVersion.getMinor() >= 2) {
                    name = library.getName();
                }
                files.put(resFolder, name);
                moduleNames.add(libraryName);
            }
        }
        catch (UnsupportedMethodException e) {
            LOG.warn("Incompatibility found between the IDE's builder-model and the cached Gradle model", (Throwable)e);
        }
        return files;
    }

    private static void addGradleLibraries(List<AndroidLibrary> list, AndroidGradleModel androidGradleModel) {
        Collection libraries = androidGradleModel.getSelectedMainCompileDependencies().getLibraries();
        HashSet unique = Sets.newHashSet();
        for (AndroidLibrary library : libraries) {
            AppResourceRepository.addGradleLibrary(list, library, unique);
        }
    }

    private static void addGradleLibrary(List<AndroidLibrary> list, AndroidLibrary library, Set<File> unique) {
        File folder = library.getFolder();
        if (!unique.add(folder)) {
            return;
        }
        list.add(library);
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            AppResourceRepository.addGradleLibrary(list, dependency, unique);
        }
    }

    @NotNull
    public List<FileResourceRepository> getLibraries() {
        return this.myLibraries;
    }

    @NotNull
    private Set<String> getAllIds() {
        long currentModCount = this.getModificationCount();
        if (this.myIdsModificationCount < currentModCount) {
            this.myIdsModificationCount = currentModCount;
            if (this.myIds == null) {
                int size = 0;
                for (FileResourceRepository library : this.myLibraries) {
                    if (library.getAllDeclaredIds() == null) continue;
                    size += library.getAllDeclaredIds().size();
                }
                this.myIds = Sets.newHashSetWithExpectedSize((int)size);
            } else {
                this.myIds.clear();
            }
            for (FileResourceRepository library : this.myLibraries) {
                if (library.getAllDeclaredIds() == null) continue;
                this.myIds.addAll(library.getAllDeclaredIds());
            }
            this.myIds.addAll(super.getItemsOfType(ResourceType.ID));
        }
        return this.myIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<String> getItemsOfType(@NotNull ResourceType type) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return type == ResourceType.ID ? this.getAllIds() : super.getItemsOfType(type);
        }
    }

    void updateRoots() {
        List<FileResourceRepository> libraries = AppResourceRepository.computeLibraries(this.myFacet);
        List<LocalResourceRepository> repositories = AppResourceRepository.computeRepositories(this.myFacet, libraries);
        this.updateRoots(repositories, libraries);
    }

    void updateRoots(List<LocalResourceRepository> resources, List<FileResourceRepository> libraries) {
        this.myResourceVisibility = null;
        this.myResourceVisibilityProvider = null;
        this.invalidateResourceDirs();
        if (resources.equals(this.myChildren)) {
            return;
        }
        this.myResourceVisibility = null;
        this.myLibraries = libraries;
        this.myAarLibraries.clear();
        for (FileResourceRepository library : this.myLibraries) {
            if (library.getResourceTextFile() == null) continue;
            this.myAarLibraries.add(library);
        }
        this.setChildren(resources);
        this.resetDynamicIds(true);
        ModuleClassLoader.clearCache(this.myFacet.getModule());
    }

    @NotNull
    static AppResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> modules, @NotNull List<FileResourceRepository> libraries) {
        assert (modules.containsAll(libraries));
        assert (modules.size() == libraries.size() + 1);
        return new AppResourceRepository(facet, modules, libraries);
    }

    @Nullable
    public FileResourceRepository findRepositoryFor(@NotNull File aarDirectory) {
        String aarPath = aarDirectory.getPath();
        assert (aarPath.endsWith(".aar") || aarPath.contains("exploded-aar")) : aarPath;
        for (LocalResourceRepository localResourceRepository : this.myLibraries) {
            if (localResourceRepository instanceof FileResourceRepository) {
                FileResourceRepository repository = (FileResourceRepository)localResourceRepository;
                if (!repository.getResourceDirectory().getPath().startsWith(aarPath)) continue;
                return repository;
            }
            assert (false) : ((Object)((Object)localResourceRepository)).getClass();
        }
        int exploded = aarPath.indexOf("exploded-aar");
        if (exploded != -1) {
            String string = aarPath.substring(exploded) + File.separator + "res";
            for (LocalResourceRepository localResourceRepository : this.myLibraries) {
                if (localResourceRepository instanceof FileResourceRepository) {
                    FileResourceRepository repository = (FileResourceRepository)localResourceRepository;
                    String path = repository.getResourceDirectory().getPath();
                    if (!path.endsWith(string)) continue;
                    return repository;
                }
                assert (false) : ((Object)((Object)localResourceRepository)).getClass();
            }
        }
        return null;
    }

    @Nullable
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.myResourceVisibilityProvider == null) {
            if (!this.myFacet.requiresAndroidModel() || this.myFacet.getAndroidModel() == null) {
                return null;
            }
            this.myResourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
        }
        return this.myResourceVisibilityProvider;
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility(@NotNull AndroidFacet facet) {
        ResourceVisibilityLookup.Provider provider;
        AndroidGradleModel androidModel = AndroidGradleModel.get(facet);
        if (androidModel != null && (provider = this.getResourceVisibilityProvider()) != null) {
            AndroidProject androidProject = androidModel.getAndroidProject();
            Variant variant = androidModel.getSelectedVariant();
            return provider.get(androidProject, variant);
        }
        return ResourceVisibilityLookup.NONE;
    }

    public boolean isPrivate(@NotNull ResourceType type, @NotNull String name) {
        if (this.myResourceVisibility == null) {
            ResourceVisibilityLookup.Provider provider = this.getResourceVisibilityProvider();
            if (provider == null) {
                return false;
            }
            AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
            if (androidModel == null) {
                return false;
            }
            this.myResourceVisibility = provider.get(androidModel.getAndroidProject(), androidModel.getSelectedVariant());
        }
        return this.myResourceVisibility.isPrivate(type, name);
    }

    @Nullable
    public Pair<ResourceType, String> resolveResourceId(int id) {
        TypedResourceName pair;
        Pair<ResourceType, String> result = null;
        if (this.myResIdValueToNameMap != null) {
            result = (Pair<ResourceType, String>)this.myResIdValueToNameMap.get(id);
        }
        if (result == null && (pair = (TypedResourceName)this.myDynamicId2ResourceMap.get(id)) != null) {
            result = pair.toPair();
        }
        return result;
    }

    @Nullable
    public String resolveStyleable(int[] id) {
        if (this.myStyleableValueToNameMap != null) {
            this.myWrapper.set(id);
            return this.myStyleableValueToNameMap.get(this.myWrapper);
        }
        return null;
    }

    @NotNull
    public Integer getResourceId(ResourceType type, String name) {
        TObjectIntHashMap<String> map;
        TObjectIntHashMap<String> tObjectIntHashMap = map = this.myResourceValueMap != null ? this.myResourceValueMap.get(type) : null;
        if (map == null || !map.containsKey((Object)name)) {
            return this.getDynamicId(type, name);
        }
        return map.get((Object)name);
    }

    @Nullable
    Integer[] getDeclaredArrayValues(List<AttrResourceValue> attrs, String styleableName) {
        ListIterator iter = this.myAarLibraries.listIterator();
        while (iter.hasNext()) {
            Integer[] in;
            FileResourceRepository repo = (FileResourceRepository)((Object)iter.next());
            File resourceTextFile = repo.getResourceTextFile();
            if (resourceTextFile == null || (in = RDotTxtParser.getDeclareStyleableArray(resourceTextFile, attrs, styleableName)) == null) continue;
            iter.remove();
            this.myAarLibraries.addFirst(repo);
            return in;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDynamicId(ResourceType type, String name) {
        TypedResourceName key = new TypedResourceName(type, name);
        TObjectIntHashMap<TypedResourceName> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            if (this.myName2DynamicIdMap.containsKey((Object)key)) {
                return this.myName2DynamicIdMap.get((Object)key);
            }
            int value = ++this.myDynamicSeed;
            this.myName2DynamicIdMap.put((Object)key, value);
            this.myDynamicId2ResourceMap.put(value, (Object)key);
            return value;
        }
    }

    public void setCompiledResources(TIntObjectHashMap<Pair<ResourceType, String>> id2res, Map<IntArrayWrapper, String> styleableId2name, Map<ResourceType, TObjectIntHashMap<String>> res2id) {
        this.resetDynamicIds(true);
        this.myResourceValueMap = res2id;
        this.myResIdValueToNameMap = id2res;
        this.myStyleableValueToNameMap = styleableId2name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetDynamicIds(boolean clearAarResourceRegistry) {
        if (clearAarResourceRegistry) {
            AarResourceClassRegistry.get(this.myFacet.getModule().getProject()).clearCache(this);
        }
        TObjectIntHashMap<TypedResourceName> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            this.myDynamicSeed = 0x7FFF0000;
            this.myName2DynamicIdMap.clear();
            this.myDynamicId2ResourceMap.clear();
        }
    }

    private static final class TypedResourceName {
        @Nullable
        final ResourceType myType;
        @NotNull
        final String myName;
        Pair<ResourceType, String> myPair;

        public TypedResourceName(@Nullable ResourceType type, @NotNull String name) {
            this.myType = type;
            this.myName = name;
        }

        public Pair<ResourceType, String> toPair() {
            if (this.myPair == null) {
                this.myPair = Pair.of((Object)this.myType, (Object)this.myName);
            }
            return this.myPair;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedResourceName that = (TypedResourceName)o;
            if (this.myType != that.myType) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myType != null ? this.myType.hashCode() : 0;
            result = 31 * result + this.myName.hashCode();
            return result;
        }

        public String toString() {
            return String.format("Type=%1$s, value=%2$s", this.myType, this.myName);
        }
    }
}

