/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.ddms.screenshot.DeviceArtPainter;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.rendering.ShadowPainter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderedImage {
    @NotNull
    private final BufferedImage myImage;
    @Nullable
    private BufferedImage myScaledImage;
    @NotNull
    private Configuration myConfiguration;
    @Nullable
    private Rectangle myImageBounds;
    private final boolean myAlphaChannelImage;
    private final ShadowType myShadowType;
    private double myScale = 1.0;
    private int myMaxWidth;
    private int myMaxHeight;
    private boolean myUseLargeShadows = true;
    private boolean myDeviceFrameEnabled = true;
    private boolean myThumbnailHasFrame;
    private static final double ZOOM_FACTOR = 1.2;

    public RenderedImage(@NotNull Configuration configuration, @NotNull BufferedImage image, boolean alphaChannelImage, @NotNull ShadowType shadowType) {
        this.myConfiguration = configuration;
        this.myImage = image;
        this.myAlphaChannelImage = alphaChannelImage;
        this.myShadowType = shadowType;
    }

    public boolean hasAlphaChannel() {
        return this.myAlphaChannelImage;
    }

    public boolean hasDropShadow() {
        return this.myShadowType != ShadowType.NONE;
    }

    public double getScale() {
        return this.myScale;
    }

    public void setScale(double scale) {
        if (this.myMaxWidth > 0) {
            assert (this.myMaxHeight > 0);
            double imageWidth = this.myImage.getWidth();
            double imageHeight = this.myImage.getHeight();
            scale = Math.min(1.0, Math.min((double)this.myMaxWidth / imageWidth, (double)this.myMaxHeight / imageHeight));
        }
        if (this.myScale != scale) {
            this.myScaledImage = null;
            this.myScale = scale;
            if (Math.abs(this.myScale - 1.0) < 0.01) {
                this.myScale = 1.0;
            }
        }
    }

    @Nullable
    public Rectangle getImageBounds() {
        if (this.myImageBounds == null && this.myScaledImage == null && this.myScale <= 1.0 && this.myDeviceFrameEnabled) {
            State deviceState;
            AndroidEditorSettings.GlobalState settings;
            DeviceArtPainter framePainter = DeviceArtPainter.getInstance();
            Device device = this.myConfiguration.getDevice();
            if (device != null && (settings = AndroidEditorSettings.getInstance().getGlobalState()).isShowDeviceFrames() && (deviceState = this.myConfiguration.getDeviceState()) != null) {
                double scale = this.myScale;
                ScreenOrientation orientation = deviceState.getOrientation();
                double frameFactor = framePainter.getFrameMaxOverhead(device, orientation);
                this.myImageBounds = framePainter.computeBounds(this.myImage.getWidth(), this.myImage.getHeight(), device, orientation, scale /= frameFactor);
                this.myThumbnailHasFrame = true;
            }
        }
        return this.myImageBounds;
    }

    public void zoomToFit(int availableWidth, int availableHeight, boolean allowZoomIn, int horizontalMargin, int verticalMargin) {
        int sceneWidth = this.myImage.getWidth();
        int sceneHeight = this.myImage.getHeight();
        int shadowSize = this.hasDropShadow() ? (this.myUseLargeShadows ? 20 : 10) : 0;
        availableWidth -= shadowSize;
        availableHeight -= shadowSize;
        if (sceneWidth > 0 && sceneHeight > 0) {
            int hDelta = availableWidth - sceneWidth;
            int xMargin = 0;
            if (hDelta > 2 * horizontalMargin) {
                xMargin = horizontalMargin;
            } else if (hDelta > 0) {
                xMargin = hDelta / 2;
            }
            int vDelta = availableHeight - sceneHeight;
            int yMargin = 0;
            if (vDelta > 2 * verticalMargin) {
                yMargin = verticalMargin;
            } else if (vDelta > 0) {
                yMargin = vDelta / 2;
            }
            double hScale = (double)(availableWidth - 2 * xMargin) / (double)sceneWidth;
            double vScale = (double)(availableHeight - 2 * yMargin) / (double)sceneHeight;
            double scale = Math.min(hScale, vScale);
            if (!allowZoomIn) {
                scale = Math.min(1.0, scale);
            }
            this.setScale(scale);
        }
    }

    public void zoomIn() {
        this.setScale(this.myScale * 1.2);
    }

    public void zoomOut() {
        this.setScale(this.myScale / 1.2);
    }

    public void zoomActual() {
        if (SystemInfo.isMac && UIUtil.isRetina()) {
            this.setScale(0.5);
        } else {
            this.setScale(1.0);
        }
    }

    @NotNull
    public BufferedImage getOriginalImage() {
        return this.myImage;
    }

    public int getOriginalWidth() {
        return this.myImage.getWidth();
    }

    public int getOriginalHeight() {
        return this.myImage.getHeight();
    }

    public int getScaledWidth() {
        return (int)(this.myScale * (double)this.myImage.getWidth());
    }

    public int getScaledHeight() {
        return (int)(this.myScale * (double)this.myImage.getHeight());
    }

    public Dimension getScaledSize() {
        return new Dimension(this.getScaledWidth(), this.getScaledHeight());
    }

    public int getRequiredWidth() {
        int width = (int)(this.myScale * (double)this.myImage.getWidth());
        if (this.myThumbnailHasFrame || this.myImageBounds == null && this.myScaledImage == null && this.myDeviceFrameEnabled && AndroidEditorSettings.getInstance().getGlobalState().isShowDeviceFrames()) {
            State deviceState;
            DeviceArtPainter framePainter = DeviceArtPainter.getInstance();
            Device device = this.myConfiguration.getDevice();
            if (device != null && (deviceState = this.myConfiguration.getDeviceState()) != null) {
                double frameFactor = framePainter.getFrameWidthOverhead(device, deviceState.getOrientation());
                width = (int)((double)width * frameFactor);
                return width;
            }
        }
        if (this.hasDropShadow()) {
            width += this.myUseLargeShadows ? 20 : 10;
        }
        return width;
    }

    public int getRequiredHeight() {
        int height = (int)(this.myScale * (double)this.myImage.getHeight());
        if (this.myThumbnailHasFrame || this.myImageBounds == null && this.myScaledImage == null && this.myDeviceFrameEnabled && AndroidEditorSettings.getInstance().getGlobalState().isShowDeviceFrames()) {
            State deviceState;
            DeviceArtPainter framePainter = DeviceArtPainter.getInstance();
            Device device = this.myConfiguration.getDevice();
            if (device != null && (deviceState = this.myConfiguration.getDeviceState()) != null) {
                double frameFactor = framePainter.getFrameHeightOverhead(device, deviceState.getOrientation());
                height = (int)((double)height * frameFactor);
                return height;
            }
        }
        if (this.hasDropShadow()) {
            height += this.myUseLargeShadows ? 20 : 10;
        }
        return height;
    }

    public Dimension getRequiredSize() {
        return new Dimension(this.getRequiredWidth(), this.getRequiredHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Graphics g, int x, int y) {
        if (UIUtil.isRetina() && this.paintRetina(g, x, y)) {
            return;
        }
        if (this.myScaledImage == null) {
            this.myImageBounds = null;
            this.myThumbnailHasFrame = false;
            if (this.myScale <= 1.0 && this.myDeviceFrameEnabled) {
                AndroidEditorSettings.GlobalState settings;
                DeviceArtPainter framePainter = DeviceArtPainter.getInstance();
                Device device = this.myConfiguration.getDevice();
                if (device != null && (settings = AndroidEditorSettings.getInstance().getGlobalState()).isShowDeviceFrames()) {
                    boolean showEffects = settings.isShowEffects();
                    State deviceState = this.myConfiguration.getDeviceState();
                    if (deviceState != null) {
                        double scale = this.myScale;
                        ScreenOrientation orientation = deviceState.getOrientation();
                        double frameFactor = framePainter.getFrameMaxOverhead(device, orientation);
                        this.myImageBounds = new Rectangle();
                        this.myScaledImage = framePainter.createFrame(this.myImage, device, orientation, showEffects, scale /= frameFactor, this.myImageBounds);
                        this.myThumbnailHasFrame = true;
                        this.paint(g, x, y);
                        return;
                    }
                }
            }
            if (this.myScale == 1.0) {
                this.myScaledImage = this.myImage;
                Device device = this.myConfiguration.getDevice();
                if (device != null && device.isScreenRound()) {
                    int imageType = this.myScaledImage.getType();
                    if (imageType == 0) {
                        imageType = 2;
                    }
                    BufferedImage clipped = new BufferedImage(this.myImage.getWidth(), this.myImage.getHeight(), imageType);
                    Graphics2D g2 = clipped.createGraphics();
                    g2.setComposite(AlphaComposite.Src);
                    g2.setColor(new Color(0, true));
                    g2.fillRect(0, 0, clipped.getWidth(), clipped.getHeight());
                    RenderedImage.paintClipped(g2, this.myImage, device, 0, 0, true);
                    g2.dispose();
                    this.myScaledImage = clipped;
                }
                if (this.myShadowType == ShadowType.RECTANGULAR) {
                    this.myScaledImage = this.myUseLargeShadows ? ShadowPainter.createRectangularDropShadow(this.myScaledImage) : ShadowPainter.createSmallRectangularDropShadow(this.myScaledImage);
                } else if (this.myShadowType == ShadowType.ARBITRARY) {
                    int shadowSize = this.myUseLargeShadows ? 20 : 10;
                    this.myScaledImage = ShadowPainter.createDropShadow(this.myScaledImage, shadowSize);
                }
                UIUtil.drawImage((Graphics)g, (Image)this.myScaledImage, (int)x, (int)y, null);
            } else if (this.myScale < 1.0) {
                if (this.myShadowType != ShadowType.NONE) {
                    int shadowSize;
                    int n = shadowSize = this.myUseLargeShadows ? 20 : 10;
                    if (this.myShadowType == ShadowType.ARBITRARY) {
                        int scaledWidth = (int)((double)this.myImage.getWidth() * this.myScale);
                        int scaledHeight = (int)((double)this.myImage.getHeight() * this.myScale);
                        Shape clip = RenderedImage.getClip(this.myConfiguration.getDevice(), 0, 0, scaledWidth, scaledHeight);
                        this.myScaledImage = ImageUtils.scale(this.myImage, this.myScale, this.myScale, clip);
                        this.myScaledImage = ShadowPainter.createDropShadow(this.myScaledImage, shadowSize);
                    } else {
                        this.myScaledImage = ImageUtils.scale(this.myImage, this.myScale, this.myScale, shadowSize, shadowSize);
                        if (this.myUseLargeShadows) {
                            ShadowPainter.drawRectangleShadow(this.myScaledImage, 0, 0, this.myScaledImage.getWidth() - shadowSize, this.myScaledImage.getHeight() - shadowSize);
                        } else {
                            ShadowPainter.drawSmallRectangleShadow(this.myScaledImage, 0, 0, this.myScaledImage.getWidth() - shadowSize, this.myScaledImage.getHeight() - shadowSize);
                        }
                    }
                } else {
                    this.myScaledImage = ImageUtils.scale(this.myImage, this.myScale, this.myScale);
                }
                UIUtil.drawImage((Graphics)g, (Image)this.myScaledImage, (int)x, (int)y, null);
            } else {
                double scale = this.myScale;
                int w = this.myImage.getWidth();
                int h = this.myImage.getHeight();
                int scaledWidth = (int)(scale * (double)w);
                int scaledHeight = (int)(scale * (double)h);
                this.myThumbnailHasFrame = false;
                Device device = this.myConfiguration.getDevice();
                boolean round = device != null && device.isScreenRound();
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    Shape prevClip = null;
                    if (round) {
                        prevClip = g.getClip();
                        int extra = 0;
                        g2.setClip(new Ellipse2D.Double(x - extra, y - extra, scaledWidth + 2 * extra, scaledHeight + 2 * extra));
                    }
                    g2.drawImage(this.myImage, x, y, x + scaledWidth, y + scaledHeight, 0, 0, w, h, null);
                    if (round) {
                        g.setClip(prevClip);
                    }
                }
                finally {
                    g2.dispose();
                }
                this.myThumbnailHasFrame = false;
                if (this.myDeviceFrameEnabled) {
                    State state;
                    AndroidEditorSettings.GlobalState settings;
                    DeviceArtPainter framePainter = DeviceArtPainter.getInstance();
                    if (device != null && (settings = AndroidEditorSettings.getInstance().getGlobalState()).isShowDeviceFrames() && (state = this.myConfiguration.getDeviceState()) != null) {
                        boolean showEffects = settings.isShowEffects();
                        framePainter.paintFrame(g, device, state.getOrientation(), showEffects, x + 1, y, scaledHeight);
                        this.myThumbnailHasFrame = true;
                        return;
                    }
                }
                if (this.hasDropShadow() && this.myShadowType == ShadowType.RECTANGULAR) {
                    ShadowPainter.drawRectangleShadow(g, x, y, scaledWidth, scaledHeight);
                }
            }
        } else {
            UIUtil.drawImage((Graphics)g, (Image)this.myScaledImage, (int)x, (int)y, null);
        }
    }

    public boolean paintRetina(@NotNull Graphics g, int x, int y) {
        if (!ImageUtils.supportsRetina()) {
            return false;
        }
        AndroidEditorSettings.GlobalState settings = AndroidEditorSettings.getInstance().getGlobalState();
        if (!settings.isRetina()) {
            return false;
        }
        if (this.myScale > 1.01) {
            return false;
        }
        if (this.myScaledImage == null) {
            this.myImageBounds = null;
            this.myThumbnailHasFrame = false;
            BufferedImage image = null;
            ShadowType shadowType = this.myShadowType;
            if (this.myScale <= 1.0 && this.myDeviceFrameEnabled) {
                DeviceArtPainter framePainter = DeviceArtPainter.getInstance();
                Device device = this.myConfiguration.getDevice();
                if (device != null && settings.isShowDeviceFrames()) {
                    boolean showEffects = settings.isShowEffects();
                    State deviceState = this.myConfiguration.getDeviceState();
                    if (deviceState != null) {
                        double scale = this.myScale;
                        ScreenOrientation orientation = deviceState.getOrientation();
                        double frameFactor = framePainter.getFrameMaxOverhead(device, orientation);
                        this.myImageBounds = new Rectangle();
                        image = framePainter.createFrame(this.myImage, device, orientation, showEffects, 2.0 * (scale /= frameFactor), this.myImageBounds);
                        this.myImageBounds.x /= 2;
                        this.myImageBounds.y /= 2;
                        this.myImageBounds.width /= 2;
                        this.myImageBounds.height /= 2;
                        this.myThumbnailHasFrame = true;
                        shadowType = ShadowType.NONE;
                    }
                }
            }
            if (image == null) {
                image = this.myImage;
                Device device = this.myConfiguration.getDevice();
                if (device != null && device.isScreenRound()) {
                    int imageType = image.getType();
                    if (imageType == 0) {
                        imageType = 2;
                    }
                    BufferedImage clipped = new BufferedImage(image.getWidth(), image.getHeight(), imageType);
                    Graphics2D g2 = clipped.createGraphics();
                    g2.setComposite(AlphaComposite.Src);
                    g2.setColor(new Color(0, true));
                    g2.fillRect(0, 0, clipped.getWidth(), clipped.getHeight());
                    RenderedImage.paintClipped(g2, image, device, 0, 0, true);
                    g2.dispose();
                    image = clipped;
                }
                double retinaScale = 2.0 * this.myScale;
                if (Math.abs(this.myScale - 1.0) > 0.01) {
                    image = ImageUtils.scale(image, retinaScale, retinaScale);
                }
            }
            this.myScaledImage = ImageUtils.convertToRetina(image);
            if (this.myScaledImage == null) {
                return false;
            }
            if (shadowType == ShadowType.RECTANGULAR) {
                this.myScaledImage = this.myUseLargeShadows ? ShadowPainter.createRectangularDropShadow(this.myScaledImage) : ShadowPainter.createSmallRectangularDropShadow(this.myScaledImage);
            } else if (shadowType == ShadowType.ARBITRARY) {
                int shadowSize = this.myUseLargeShadows ? 20 : 10;
                this.myScaledImage = ShadowPainter.createDropShadow(this.myScaledImage, shadowSize);
            }
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myScaledImage, (int)x, (int)y, null);
        return true;
    }

    public void setMaxSize(int width, int height) {
        this.myMaxWidth = width;
        this.myMaxHeight = height;
        this.zoomActual();
    }

    public int getMaxWidth() {
        return this.myMaxWidth;
    }

    public int getMaxHeight() {
        return this.myMaxHeight;
    }

    public void setUseLargeShadows(boolean useLargeShadows) {
        this.myUseLargeShadows = useLargeShadows;
    }

    public void setDeviceFrameEnabled(boolean deviceFrameEnabled) {
        if (this.myDeviceFrameEnabled != deviceFrameEnabled) {
            this.myDeviceFrameEnabled = deviceFrameEnabled;
            this.myScaledImage = null;
        }
    }

    @Nullable
    public Boolean isFramed() {
        if (this.myScaledImage == null) {
            return null;
        }
        return this.myThumbnailHasFrame;
    }

    public boolean getShowDropShadow() {
        return this.myShadowType != ShadowType.NONE;
    }

    public void imageChanged() {
        this.myScaledImage = null;
        this.myImageBounds = null;
    }

    @Nullable
    public static Shape getClip(@Nullable Device device, int x, int y, int width, int height) {
        boolean round;
        boolean bl = round = device != null && device.isScreenRound();
        if (round) {
            int slop = 3;
            return new Ellipse2D.Double(x - slop, y - slop, width + 2 * slop, height + 2 * slop);
        }
        return null;
    }

    public static void paintClipped(@NotNull Graphics2D g, @NotNull BufferedImage image, @Nullable Device device, int x, int y, boolean withRetina) {
        Shape prevClip = null;
        Shape clip = RenderedImage.getClip(device, x, y, image.getWidth(), image.getHeight());
        if (clip != null) {
            prevClip = g.getClip();
            g.setClip(clip);
        }
        if (withRetina) {
            UIUtil.drawImage((Graphics)g, (Image)image, (int)x, (int)y, null);
        } else {
            g.drawImage((Image)image, x, y, null);
        }
        if (clip != null) {
            g.setClip(prevClip);
        }
    }

    static enum ShadowType {
        NONE,
        RECTANGULAR,
        ARBITRARY;

    }
}

