/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.RenderedImage;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderResult {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final RenderLogger myLogger;
    @Nullable
    private final List<ViewInfo> myRootViews;
    @Nullable
    private final List<ViewInfo> mySystemRootViews;
    @Nullable
    private final RenderedImage myImage;
    @Nullable
    private final RenderTask myRenderTask;
    @NotNull
    private final Result myRenderResult;
    @Nullable
    private IncludeReference myIncludedWithin = IncludeReference.NONE;
    @NotNull
    private final Rectangle myImageBounds;
    @NotNull
    private final Map<Object, PropertiesMap> myDefaultProperties;

    public RenderResult(@Nullable RenderTask renderTask, @Nullable RenderSession session, @NotNull PsiFile file, @NotNull RenderLogger logger) {
        this.myRenderTask = renderTask;
        this.myFile = file;
        this.myLogger = logger;
        Result result = this.myRenderResult = session != null ? session.getResult() : Result.Status.ERROR_UNKNOWN.createResult("Failed to initialize session");
        if (session != null && this.myRenderResult.isSuccess() && renderTask != null) {
            RenderedImage.ShadowType shadowType;
            List rootViews = session.getRootViews();
            this.myRootViews = rootViews != null ? ImmutableList.copyOf((Collection)rootViews) : null;
            List systemRootViews = session.getSystemRootViews();
            this.mySystemRootViews = systemRootViews != null ? ImmutableList.copyOf((Collection)systemRootViews) : null;
            Configuration configuration = renderTask.getConfiguration();
            BufferedImage image = session.getImage();
            boolean alphaChannelImage = session.isAlphaChannelImage() || renderTask.requiresTransparency();
            RenderedImage.ShadowType shadowType2 = shadowType = alphaChannelImage ? RenderedImage.ShadowType.NONE : RenderedImage.ShadowType.RECTANGULAR;
            if (shadowType == RenderedImage.ShadowType.NONE && renderTask.isNonRectangular()) {
                shadowType = RenderedImage.ShadowType.ARBITRARY;
            } else {
                Device device = renderTask.getConfiguration().getDevice();
                if (device != null && device.isScreenRound()) {
                    shadowType = RenderedImage.ShadowType.ARBITRARY;
                }
            }
            this.myImage = image != null ? new RenderedImage(configuration, image, alphaChannelImage, shadowType) : null;
            Map defaultProperties = session.getDefaultProperties();
            this.myDefaultProperties = defaultProperties != null ? defaultProperties : Collections.emptyMap();
        } else {
            this.myRootViews = null;
            this.mySystemRootViews = null;
            this.myImage = null;
            this.myDefaultProperties = Collections.emptyMap();
        }
        this.myImageBounds = new Rectangle(0, 0, this.myImage != null ? this.myImage.getOriginalWidth() : 0, this.myImage != null ? this.myImage.getOriginalHeight() : 0);
    }

    @NotNull
    public static RenderResult createBlank(@NotNull PsiFile file, @Nullable RenderLogger logger) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return new RenderResult(null, null, file, logger != null ? logger : new RenderLogger(null, module));
    }

    @NotNull
    public Result getRenderResult() {
        return this.myRenderResult;
    }

    @NotNull
    public RenderLogger getLogger() {
        return this.myLogger;
    }

    @Nullable
    public RenderedImage getImage() {
        return this.myImage;
    }

    @Nullable
    public BufferedImage getRenderedImage() {
        return this.myImage != null ? this.myImage.getOriginalImage() : null;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @Nullable
    public RenderTask getRenderTask() {
        return this.myRenderTask;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myLogger.getModule();
        assert (module != null);
        return module;
    }

    @Nullable
    public List<ViewInfo> getRootViews() {
        return this.myRootViews;
    }

    @Nullable
    public List<ViewInfo> getSystemRootViews() {
        return this.mySystemRootViews;
    }

    @Nullable
    public IncludeReference getIncludedWithin() {
        return this.myIncludedWithin;
    }

    public void setIncludedWithin(@Nullable IncludeReference includedWithin) {
        this.myIncludedWithin = includedWithin;
    }

    @NotNull
    public Rectangle getOriginalBounds() {
        return this.myImageBounds;
    }

    @NotNull
    public Map<Object, PropertiesMap> getDefaultProperties() {
        return this.myDefaultProperties;
    }
}

