/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.ClassConverter;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.lang.UrlClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderClassLoader
extends ClassLoader {
    protected static final Logger LOG = Logger.getInstance(RenderClassLoader.class);
    protected UrlClassLoader myJarClassLoader;
    protected boolean myInsideJarClassLoader;
    protected final int myLayoutlibApiLevel;

    public RenderClassLoader(@Nullable ClassLoader parent, int layoutlibApiLevel) {
        super(parent);
        this.myLayoutlibApiLevel = layoutlibApiLevel;
    }

    protected abstract List<URL> getExternalJars();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.load(name);
    }

    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> clz = this.loadClassFromJar(name);
        if (clz != null) {
            return clz;
        }
        throw new ClassNotFoundException(name);
    }

    @Nullable
    protected Class<?> loadClassFromJar(@NotNull String name) {
        if (this.myJarClassLoader == null) {
            List<URL> externalJars = this.getExternalJars();
            this.myJarClassLoader = this.createClassLoader(externalJars);
        }
        try {
            this.myInsideJarClassLoader = true;
            String relative = name.replace('.', '/').concat(".class");
            InputStream is = this.myJarClassLoader.getResourceAsStream(relative);
            if (is != null) {
                byte[] data = ByteStreams.toByteArray((InputStream)is);
                is.close();
                if (!ClassConverter.isValidClassFile(data)) {
                    throw new ClassFormatError(name);
                }
                byte[] rewritten = this.convertClass(data);
                try {
                    Class<?> clazz = this.defineClassAndPackage(name, rewritten, 0, rewritten.length);
                    return clazz;
                }
                catch (UnsupportedClassVersionError inner) {
                    throw InconvertibleClassError.wrap(inner, name, data);
                }
            }
            Class<?> clazz = null;
            return clazz;
        }
        catch (IOException ex) {
            throw new Error("Failed to load class " + name, ex);
        }
        finally {
            this.myInsideJarClassLoader = false;
        }
    }

    protected UrlClassLoader createClassLoader(List<URL> externalJars) {
        return UrlClassLoader.build().parent((ClassLoader)this).urls(externalJars).noPreload().get();
    }

    @Nullable
    protected Class<?> loadClassFile(String fqcn, @NotNull VirtualFile classFile) {
        try {
            byte[] data = classFile.contentsToByteArray();
            return this.loadClass(fqcn, data);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Class<?> loadClass(@NotNull String fqcn, @Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        if (!ClassConverter.isValidClassFile(data)) {
            throw new ClassFormatError(fqcn);
        }
        byte[] rewritten = this.convertClass(data);
        try {
            return this.defineClassAndPackage(fqcn, rewritten, 0, rewritten.length);
        }
        catch (UnsupportedClassVersionError inner) {
            throw InconvertibleClassError.wrap(inner, fqcn, data);
        }
    }

    @NotNull
    protected byte[] convertClass(@NotNull byte[] data) {
        return ClassConverter.rewriteClass(data, this.myLayoutlibApiLevel);
    }

    @NotNull
    protected Class<?> defineClassAndPackage(@NotNull String name, @NotNull byte[] b, int offset, int len) {
        String packageName;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i > 0 && (pkg = this.getPackage(packageName = name.substring(0, i))) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        return this.defineClass(name, b, offset, len);
    }
}

