/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.LayoutLog;
import com.android.resources.Density;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.TagSnapshot;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PaddingLayoutPsiPullParser
extends LayoutPsiPullParser {
    private static final Pattern FLOAT_PATTERN = Pattern.compile("(-?[0-9]+(?:\\.[0-9]+)?)(.*)");
    private static final int PADDING_VALUE = 10;
    private boolean myZeroAttributeIsPadding = false;
    private boolean myIncreaseExistingPadding = false;
    @NotNull
    private final Density myDensity;
    private static final String DEFAULT_PADDING_VALUE = "10px";
    private static final String FIXED_PADDING_VALUE = "20px";
    private final Set<XmlTag> myExplodeNodes;
    private static final int COMPLEX_UNIT_PX = 0;
    private static final int COMPLEX_UNIT_DIP = 1;
    private static final int COMPLEX_UNIT_SP = 2;
    private static final int COMPLEX_UNIT_PT = 3;
    private static final int COMPLEX_UNIT_IN = 4;
    private static final int COMPLEX_UNIT_MM = 5;
    private static final DimensionEntry[] DIMENSIONS = new DimensionEntry[]{new DimensionEntry("px", 0), new DimensionEntry("dip", 1), new DimensionEntry("dp", 1), new DimensionEntry("sp", 2), new DimensionEntry("pt", 3), new DimensionEntry("in", 4), new DimensionEntry("mm", 5)};
    private int myLastPixel;

    PaddingLayoutPsiPullParser(@NotNull XmlFile file, @NotNull RenderLogger logger, @NotNull Set<XmlTag> explodeNodes, @NotNull Density density) {
        super(file, (LayoutLog)logger);
        this.myExplodeNodes = explodeNodes;
        this.myDensity = density;
    }

    @Override
    protected void push(@NotNull TagSnapshot node) {
        super.push(node);
        this.myZeroAttributeIsPadding = false;
        this.myIncreaseExistingPadding = false;
    }

    @Override
    public int getAttributeCount() {
        int count = super.getAttributeCount();
        return count + (this.myZeroAttributeIsPadding ? 1 : 0);
    }

    @Override
    public String getAttributeName(int i) {
        if (this.myZeroAttributeIsPadding) {
            if (i == 0) {
                return "padding";
            }
            --i;
        }
        return super.getAttributeName(i);
    }

    @Override
    public String getAttributeNamespace(int i) {
        if (this.myZeroAttributeIsPadding) {
            if (i == 0) {
                return "http://schemas.android.com/apk/res/android";
            }
            --i;
        }
        return super.getAttributeNamespace(i);
    }

    @Override
    public String getAttributePrefix(int i) {
        if (this.myZeroAttributeIsPadding) {
            if (i == 0) {
                assert (this.myRoot != null);
                return this.myAndroidPrefix;
            }
            --i;
        }
        return super.getAttributePrefix(i);
    }

    @Override
    public String getAttributeValue(int i) {
        AttributeSnapshot attribute;
        if (this.myZeroAttributeIsPadding) {
            if (i == 0) {
                return DEFAULT_PADDING_VALUE;
            }
            --i;
        }
        if ((attribute = this.getAttribute(i)) != null) {
            String value = attribute.value;
            if (value != null && this.myIncreaseExistingPadding && "padding".equals(attribute.name) && "http://schemas.android.com/apk/res/android".equals(attribute.namespace)) {
                return this.addPaddingToValue(value);
            }
            return value;
        }
        return null;
    }

    @Override
    public String getAttributeValue(String namespace, String localName) {
        TagSnapshot node;
        boolean isPaddingAttribute = "padding".equals(localName);
        if (isPaddingAttribute && "http://schemas.android.com/apk/res/android".equals(namespace) && (node = this.getCurrentNode()) != null && this.myExplodeNodes.contains(node.tag)) {
            return FIXED_PADDING_VALUE;
        }
        if (this.myZeroAttributeIsPadding && isPaddingAttribute && "http://schemas.android.com/apk/res/android".equals(namespace)) {
            return DEFAULT_PADDING_VALUE;
        }
        String value = super.getAttributeValue(namespace, localName);
        if (value != null && this.myIncreaseExistingPadding && isPaddingAttribute && "http://schemas.android.com/apk/res/android".equals(namespace)) {
            return this.addPaddingToValue(value);
        }
        return value;
    }

    private String addPaddingToValue(String s) {
        if (s == null) {
            return DEFAULT_PADDING_VALUE;
        }
        int padding = 10;
        if (this.stringToPixel(s)) {
            padding += this.myLastPixel;
        }
        return padding + "px";
    }

    private boolean stringToPixel(String s) {
        int len = (s = s.trim()).length();
        if (len <= 0) {
            return false;
        }
        char[] buf = s.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= '\u00ff') continue;
            return false;
        }
        if (buf[0] < '0' && buf[0] > '9' && buf[0] != '.' && buf[0] != '-') {
            return false;
        }
        Matcher m = FLOAT_PATTERN.matcher(s);
        if (m.matches()) {
            DimensionEntry dimension;
            float f;
            String f_str = m.group(1);
            String end = m.group(2);
            try {
                f = Float.parseFloat(f_str);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (end.length() > 0 && end.charAt(0) != ' ' && (dimension = PaddingLayoutPsiPullParser.parseDimension(end)) != null) {
                switch (dimension.type) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        f *= (float)this.myDensity.getDpiValue() / 160.0f;
                        break;
                    }
                    case 3: {
                        f *= (float)this.myDensity.getDpiValue() * 0.013888889f;
                        break;
                    }
                    case 4: {
                        f *= (float)this.myDensity.getDpiValue();
                        break;
                    }
                    case 5: {
                        f *= (float)this.myDensity.getDpiValue() * 0.03937008f;
                    }
                }
                this.myLastPixel = (int)((double)f + 0.5);
                return true;
            }
        }
        return false;
    }

    private static DimensionEntry parseDimension(String str) {
        str = str.trim();
        for (DimensionEntry d : DIMENSIONS) {
            if (!d.name.equals(str)) continue;
            return d;
        }
        return null;
    }

    private static final class DimensionEntry {
        final String name;
        final int type;

        DimensionEntry(String name, int unit) {
            this.name = name;
            this.type = unit;
        }
    }
}

