/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.legacy.ILegacyPullParser;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.MenuLayoutParserFactory;
import com.android.tools.idea.rendering.MenuPreviewRenderer;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class LayoutPullParserFactory {
    static final boolean DEBUG = false;

    public static boolean isSupported(@NotNull PsiFile file) {
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        if (folderType == null) {
            return false;
        }
        switch (folderType) {
            case LAYOUT: 
            case DRAWABLE: 
            case MENU: {
                return true;
            }
            case XML: {
                if (file instanceof XmlFile) {
                    ApplicationManager.getApplication().assertReadAccessAllowed();
                    XmlTag rootTag = ((XmlFile)file).getRootTag();
                    if (rootTag != null) {
                        String tag = rootTag.getName();
                        return tag.equals("appwidget-provider") || tag.equals("PreferenceScreen") && LayoutPullParserFactory.prefCapableTargetInstalled(file);
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static boolean prefCapableTargetInstalled(@NotNull PsiFile file) {
        AndroidPlatform platform;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null && (platform = AndroidPlatform.getInstance(module)) != null) {
            IAndroidTarget[] targets = platform.getSdkData().getTargets();
            for (int i = targets.length - 1; i >= 0; --i) {
                AndroidVersion version;
                int featureLevel;
                IAndroidTarget target = targets[i];
                if (!target.isPlatform() || (featureLevel = (version = target.getVersion()).getFeatureLevel()) < 22) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static ILayoutPullParser create(@NotNull RenderTask renderTask) {
        ResourceFolderType folderType = renderTask.getFolderType();
        if (folderType == null) {
            return null;
        }
        if (!(folderType != ResourceFolderType.DRAWABLE && folderType != ResourceFolderType.MENU && folderType != ResourceFolderType.XML || ApplicationManager.getApplication().isReadAccessAllowed())) {
            return (ILayoutPullParser)ApplicationManager.getApplication().runReadAction(() -> LayoutPullParserFactory.create(renderTask));
        }
        XmlFile file = renderTask.getPsiFile();
        if (file == null) {
            throw new IllegalArgumentException("RenderTask always should always have PsiFile when it has ResourceFolderType");
        }
        switch (folderType) {
            case LAYOUT: {
                RenderLogger logger = renderTask.getLogger();
                Set<XmlTag> expandNodes = renderTask.getExpandNodes();
                HardwareConfig hardwareConfig = renderTask.getHardwareConfigHelper().getConfig();
                return LayoutPsiPullParser.create(file, logger, expandNodes, hardwareConfig.getDensity());
            }
            case DRAWABLE: {
                renderTask.setDecorations(false);
                return LayoutPullParserFactory.createDrawableParser(file);
            }
            case MENU: {
                if (renderTask.supportsCapability(12)) {
                    return new MenuLayoutParserFactory(renderTask).render();
                }
                renderTask.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
                renderTask.setDecorations(false);
                return new MenuPreviewRenderer(renderTask, file).render();
            }
            case XML: {
                XmlTag rootTag = file.getRootTag();
                if (rootTag != null) {
                    String tag = rootTag.getName();
                    if (tag.equals("appwidget-provider")) {
                        renderTask.setDecorations(false);
                        return LayoutPullParserFactory.createWidgetParser(rootTag);
                    }
                    if (tag.equals("PreferenceScreen")) {
                        RenderLogger logger = renderTask.getLogger();
                        Set<XmlTag> expandNodes = renderTask.getExpandNodes();
                        HardwareConfig hardwareConfig = renderTask.getHardwareConfigHelper().getConfig();
                        return LayoutPsiPullParser.create(file, logger, expandNodes, hardwareConfig.getDensity());
                    }
                }
                return null;
            }
        }
        assert (false) : folderType;
        return null;
    }

    private static ILegacyPullParser createDrawableParser(XmlFile file) {
        String scaleType;
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element imageView = LayoutPullParserFactory.addRootElement(document, "ImageView");
        LayoutPullParserFactory.setAndroidAttr(imageView, "layout_width", "fill_parent");
        LayoutPullParserFactory.setAndroidAttr(imageView, "layout_height", "fill_parent");
        LayoutPullParserFactory.setAndroidAttr(imageView, "src", "@drawable/" + ResourceHelper.getResourceName((PsiFile)file));
        String background = AndroidPsiUtils.getRootTagAttributeSafely(file, "background", "http://schemas.android.com/tools");
        if (background != null && !background.isEmpty()) {
            LayoutPullParserFactory.setAndroidAttr(imageView, "background", background);
        }
        if ((scaleType = AndroidPsiUtils.getRootTagAttributeSafely(file, "scaleType", "http://schemas.android.com/tools")) != null && !scaleType.isEmpty()) {
            LayoutPullParserFactory.setAndroidAttr(imageView, "scaleType", scaleType);
        }
        return new DomPullParser(document.getDocumentElement());
    }

    @Nullable
    private static ILayoutPullParser createWidgetParser(XmlTag rootTag) {
        String layout = rootTag.getAttributeValue("initialLayout", "http://schemas.android.com/apk/res/android");
        String preview = rootTag.getAttributeValue("previewImage", "http://schemas.android.com/apk/res/android");
        if (layout == null && preview == null) {
            return null;
        }
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root = LayoutPullParserFactory.addRootElement(document, layout != null ? "include" : "ImageView");
        if (layout != null) {
            root.setAttribute("layout", layout);
            LayoutPullParserFactory.setAndroidAttr(root, "layout_width", "fill_parent");
            LayoutPullParserFactory.setAndroidAttr(root, "layout_height", "fill_parent");
        } else {
            root.setAttribute("src", preview);
            LayoutPullParserFactory.setAndroidAttr(root, "layout_width", "wrap_content");
            LayoutPullParserFactory.setAndroidAttr(root, "layout_height", "wrap_content");
        }
        return new DomPullParser(document.getDocumentElement());
    }

    public static boolean needSave(@Nullable ResourceFolderType type) {
        return type != ResourceFolderType.LAYOUT;
    }

    public static void saveFileIfNecessary(PsiFile psiFile) {
        if (!LayoutPullParserFactory.needSave(ResourceHelper.getFolderType(psiFile.getVirtualFile()))) {
            return;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return;
        }
        FileDocumentManager fileManager = FileDocumentManager.getInstance();
        if (!fileManager.isFileModified(file)) {
            return;
        }
        Document document = fileManager.getCachedDocument(file);
        if (document == null || !fileManager.isDocumentUnsaved(document)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> fileManager.saveDocument(document)), ModalityState.any());
    }

    protected static Element addRootElement(@NotNull org.w3c.dom.Document document, @NotNull String tag) {
        Element root = document.createElement(tag);
        Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:android");
        attr.setValue("http://schemas.android.com/apk/res/android");
        root.getAttributes().setNamedItemNS(attr);
        document.appendChild(root);
        return root;
    }

    protected static Element setAndroidAttr(Element element, String name, String value) {
        element.setAttributeNS("http://schemas.android.com/apk/res/android", name, value);
        return element;
    }

    public static ILegacyPullParser createEmptyParser() {
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root = LayoutPullParserFactory.addRootElement(document, "FrameLayout");
        LayoutPullParserFactory.setAndroidAttr(root, "layout_width", "fill_parent");
        LayoutPullParserFactory.setAndroidAttr(root, "layout_height", "fill_parent");
        return new DomPullParser(document.getDocumentElement());
    }
}

