/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template.components;

import com.android.tools.idea.npw.template.components.ParameterComponentProvider;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.google.common.base.Strings;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActivityComboProvider
extends ParameterComponentProvider<ReferenceEditorComboWithBrowseButton> {
    @NotNull
    private final Module myModule;
    @NotNull
    private final String myRecentsKey;

    public ActivityComboProvider(@NotNull Module module, @NotNull Parameter parameter, @NotNull String recentsKey) {
        super(parameter);
        this.myModule = module;
        this.myRecentsKey = recentsKey;
    }

    @Override
    @NotNull
    protected ReferenceEditorComboWithBrowseButton createComponent(@NotNull Parameter parameter) {
        ChooseClassActionListener browseAction = new ChooseClassActionListener(this.myModule);
        RecentsManager recentsManager = RecentsManager.getInstance((Project)this.myModule.getProject());
        recentsManager.registerRecentEntry(this.myRecentsKey, "");
        ReferenceEditorComboWithBrowseButton control = new ReferenceEditorComboWithBrowseButton((ActionListener)browseAction, "", this.myModule.getProject(), true, (JavaCodeFragment.VisibilityChecker)new OnlyShowActivities(this.myModule), this.myRecentsKey);
        browseAction.setOwner(control);
        return control;
    }

    @Override
    @Nullable
    public AbstractProperty<?> createProperty(@NotNull ReferenceEditorComboWithBrowseButton component) {
        return new TextProperty((EditorComboBox)component.getChildComponent());
    }

    @Override
    public void accept(@NotNull ReferenceEditorComboWithBrowseButton component) {
        RecentsManager recentsManager = RecentsManager.getInstance((Project)this.myModule.getProject());
        recentsManager.registerRecentEntry(this.myRecentsKey, component.getText());
    }

    private static final class ChooseClassActionListener
    implements ActionListener {
        @NotNull
        private final Module myModule;
        @Nullable
        private ReferenceEditorComboWithBrowseButton myOwner;

        public ChooseClassActionListener(@NotNull Module module) {
            this.myModule = module;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final OnlyShowActivities filter = new OnlyShowActivities(this.myModule);
            Project project = this.myModule.getProject();
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createWithInnerClassesScopeChooser("Select Activity", GlobalSearchScope.projectScope((Project)project), new ClassFilter(){

                public boolean isAccepted(PsiClass psiClass) {
                    return filter.isDeclarationVisible((PsiElement)psiClass, null) == JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                }
            }, null);
            assert (this.myOwner != null);
            String currClass = this.myOwner.getText();
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(currClass, GlobalSearchScope.allScope((Project)project));
            if (psiClass != null) {
                chooser.selectDirectory(psiClass.getContainingFile().getContainingDirectory());
            }
            chooser.showDialog();
            PsiClass selectedClass = chooser.getSelected();
            if (selectedClass != null) {
                this.myOwner.setText(Strings.nullToEmpty((String)selectedClass.getQualifiedName()));
            }
        }

        public void setOwner(@NotNull ReferenceEditorComboWithBrowseButton owner) {
            this.myOwner = owner;
        }
    }

    private static final class OnlyShowActivities
    implements JavaCodeFragment.VisibilityChecker {
        @NotNull
        private final Module myModule;

        public OnlyShowActivities(@NotNull Module module) {
            this.myModule = module;
        }

        private static boolean isActivitySubclass(@NotNull PsiClass classDecl) {
            for (PsiClass superClass : classDecl.getSupers()) {
                String typename = superClass.getQualifiedName();
                if (!"android.app.Activity".equals(typename) && !OnlyShowActivities.isActivitySubclass(superClass)) continue;
                return true;
            }
            return false;
        }

        public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, @Nullable PsiElement place) {
            PsiClass classDecl;
            if (declaration instanceof PsiClass && PsiClassUtil.isRunnableClass((PsiClass)(classDecl = (PsiClass)declaration), (boolean)true, (boolean)true) && OnlyShowActivities.isActivitySubclass(classDecl) && this.isOnClasspath(classDecl)) {
                return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
            }
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }

        private boolean isOnClasspath(@NotNull PsiClass classDecl) {
            GlobalSearchScope scope = this.myModule.getModuleWithDependenciesAndLibrariesScope(false);
            VirtualFile file = classDecl.getContainingFile().getVirtualFile();
            return scope.contains(file);
        }
    }
}

