/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IconLoader
extends CacheLoader<File, Optional<Icon>> {
    IconLoader() {
    }

    public static LoadingCache<File, Optional<Icon>> createLoadingCache() {
        return CacheBuilder.newBuilder().build((CacheLoader)new IconLoader());
    }

    private static Logger getLog() {
        return Logger.getInstance(IconLoader.class);
    }

    @Nullable
    public Optional<Icon> load(@NotNull File iconPath) {
        try {
            if (iconPath.isFile()) {
                BufferedImage image = ImageIO.read(iconPath);
                if (image != null) {
                    return Optional.of((Object)new ImageIcon(image.getScaledInstance(256, 256, 4)));
                }
                IconLoader.getLog().warn("File " + iconPath.getAbsolutePath() + " exists but is not a valid image");
            } else {
                IconLoader.getLog().warn("Image file " + iconPath.getAbsolutePath() + " was not found");
            }
        }
        catch (IOException e) {
            IconLoader.getLog().warn((Throwable)e);
        }
        return Optional.absent();
    }
}

