/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsPanel;
import com.android.tools.idea.npw.template.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.templates.StringEvaluator;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Strings;
import java.util.Locale;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class GenerateIconsStep
extends ModelWizardStep<RenderTemplateModel> {
    private final StudioWizardStepPanel myStudioPanel;
    private final GenerateIconsPanel myGenerateIconsPanel;
    private final ListenerManager myListeners = new ListenerManager();

    public GenerateIconsStep(@NotNull RenderTemplateModel model) {
        super(model, "Generate Icons");
        AndroidIconType iconType = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getIconType();
        assert (iconType != null);
        this.myGenerateIconsPanel = new GenerateIconsPanel(this, ((RenderTemplateModel)this.getModel()).getFacet(), iconType);
        this.myListeners.listenAndFire(model.getSourceSet(), new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                GenerateIconsStep.this.myGenerateIconsPanel.setProjectPaths(((RenderTemplateModel)GenerateIconsStep.this.getModel()).getPaths());
            }
        });
        this.myStudioPanel = new StudioWizardStepPanel(this.myGenerateIconsPanel, "Convert a source asset into " + iconType.getDisplayName().toLowerCase(Locale.getDefault()));
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioPanel;
    }

    @Override
    protected void onEntering() {
        TemplateHandle templateHandle = ((RenderTemplateModel)this.getModel()).getTemplateHandle();
        String iconNameExpression = templateHandle.getMetadata().getIconName();
        String iconName = null;
        if (iconNameExpression != null && !iconNameExpression.isEmpty()) {
            StringEvaluator evaluator = new StringEvaluator();
            iconName = evaluator.evaluate(iconNameExpression, ((RenderTemplateModel)this.getModel()).getTemplateValues());
        }
        this.myGenerateIconsPanel.setOutputName(Strings.nullToEmpty(iconName));
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myGenerateIconsPanel.hasErrors().not();
    }

    @Override
    protected void onProceeding() {
        ((RenderTemplateModel)this.getModel()).setIconGenerator(this.myGenerateIconsPanel.getIconGenerator());
    }

    @Override
    public void dispose() {
        this.myListeners.releaseAll();
    }
}

