/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.deprecated;

import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.npw.deprecated.ConfigureAndroidProjectPath;
import com.android.tools.idea.ui.LabelWithEditLink;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidProjectStep
extends DynamicWizardStepWithHeaderAndDescription {
    private static final String EXAMPLE_DOMAIN = "example.com";
    public static final String SAVED_COMPANY_DOMAIN = "SAVED_COMPANY_DOMAIN";
    private TextFieldWithBrowseButton myProjectLocation;
    private JTextField myAppName;
    private JPanel myPanel;
    private JTextField myCompanyDomain;
    private LabelWithEditLink myPackageName;
    private JBCheckBox myIncludeCppCheck;
    public static final ScopedDataBinder.ValueDeriver<String> PACKAGE_NAME_DERIVER = new ScopedDataBinder.ValueDeriver<String>(){

        @Override
        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return 2.makeSetOf(WizardConstants.APPLICATION_NAME_KEY, WizardConstants.COMPANY_DOMAIN_KEY);
        }

        @Override
        @Nullable
        public String deriveValue(@NotNull ScopedStateStore state, ScopedStateStore.Key changedKey, @Nullable String currentValue) {
            String projectName = state.get(WizardConstants.APPLICATION_NAME_KEY);
            if (projectName == null) {
                projectName = "app";
            }
            projectName = ConfigureAndroidProjectStep.nameToPackage(projectName);
            String companyDomain = state.get(WizardConstants.COMPANY_DOMAIN_KEY);
            if (companyDomain == null) {
                companyDomain = ConfigureAndroidProjectStep.EXAMPLE_DOMAIN;
            }
            ArrayList domainParts = Lists.newArrayList((Object[])companyDomain.split("\\."));
            String reversedDomain = Joiner.on((char)'.').skipNulls().join((Iterable)Lists.reverse((List)Lists.transform((List)domainParts, (Function)new Function<String, String>(){

                public String apply(String input) {
                    String name = ConfigureAndroidProjectStep.nameToPackage(input);
                    return name.isEmpty() ? null : name;
                }
            })));
            return reversedDomain + '.' + projectName;
        }
    };
    private static final ScopedDataBinder.ValueDeriver<String> myProjectLocationDeriver = new ScopedDataBinder.ValueDeriver<String>(){

        @Override
        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return 3.makeSetOf(WizardConstants.APPLICATION_NAME_KEY);
        }

        @Override
        @Nullable
        public String deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable String currentValue) {
            String name = state.get(WizardConstants.APPLICATION_NAME_KEY);
            name = name == null ? "" : name;
            name = name.replaceAll("[/\\\\?%*:|\"<>!;]", "");
            name = name.replaceAll("\\s", "");
            File baseDirectory = WizardUtils.getProjectLocationParent();
            File projectDir = new File(baseDirectory, name);
            int i = 2;
            while (projectDir.exists()) {
                projectDir = new File(baseDirectory, name + i);
                ++i;
            }
            return projectDir.getPath();
        }
    };

    public ConfigureAndroidProjectStep(@NotNull Disposable disposable) {
        this("Configure your new project", disposable);
    }

    public ConfigureAndroidProjectStep(String title, Disposable parentDisposable) {
        super(title, null, parentDisposable);
        this.$$$setupUI$$$();
        this.setBodyComponent(this.myPanel);
    }

    @Override
    public void init() {
        this.register(WizardConstants.APPLICATION_NAME_KEY, this.myAppName);
        this.register(WizardConstants.COMPANY_DOMAIN_KEY, this.myCompanyDomain);
        this.register(WizardConstants.PACKAGE_NAME_KEY, this.myPackageName);
        this.registerValueDeriver(WizardConstants.PACKAGE_NAME_KEY, PACKAGE_NAME_DERIVER);
        this.register(WizardConstants.PROJECT_LOCATION_KEY, this.myProjectLocation);
        this.registerValueDeriver(WizardConstants.PROJECT_LOCATION_KEY, myProjectLocationDeriver);
        this.register(WizardConstants.INCLUDE_CPP_SUPPORT_KEY, (JCheckBox)this.myIncludeCppCheck);
        this.myProjectLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureAndroidProjectStep.this.browseForFile();
            }
        });
        this.myState.put(WizardConstants.APPLICATION_NAME_KEY, "My Application");
        String savedCompanyDomain = PropertiesComponent.getInstance().getValue(SAVED_COMPANY_DOMAIN);
        if (savedCompanyDomain == null && (savedCompanyDomain = ConfigureAndroidProjectStep.nameToPackage(System.getProperty("user.name"))) != null) {
            savedCompanyDomain = savedCompanyDomain + '.' + EXAMPLE_DOMAIN;
        }
        if (savedCompanyDomain == null) {
            savedCompanyDomain = EXAMPLE_DOMAIN;
        }
        this.myState.put(WizardConstants.COMPANY_DOMAIN_KEY, savedCompanyDomain);
        super.init();
    }

    private void browseForFile() {
        FileSaverDescriptor fileSaverDescriptor = new FileSaverDescriptor("Project location", "Please choose a location for your project", new String[0]);
        File currentPath = new File(this.myProjectLocation.getText());
        File parentPath = currentPath.getParentFile();
        if (parentPath == null) {
            String homePath = System.getProperty("user.home");
            parentPath = new File(homePath == null ? "/" : homePath);
        }
        VirtualFile parent = LocalFileSystem.getInstance().findFileByIoFile(parentPath);
        String filename = currentPath.getName();
        VirtualFileWrapper fileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(fileSaverDescriptor, (Project)null).save(parent, filename);
        if (fileWrapper != null) {
            this.myProjectLocation.setText(fileWrapper.getFile().getAbsolutePath());
        }
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        String message;
        String domain;
        super.deriveValues(modified);
        if (modified.contains(WizardConstants.COMPANY_DOMAIN_KEY) && (domain = this.myState.get(WizardConstants.COMPANY_DOMAIN_KEY)) != null && !domain.isEmpty() && this.myState.containsKey(WizardConstants.PACKAGE_NAME_KEY) && (message = AndroidUtils.validateAndroidPackageName(this.myState.get(WizardConstants.PACKAGE_NAME_KEY))) == null) {
            PropertiesComponent.getInstance().setValue(SAVED_COMPANY_DOMAIN, domain);
        }
    }

    @Override
    public boolean validate() {
        if (!this.myPath.validate()) {
            return false;
        }
        WizardUtils.ValidationResult locationValidationResult = WizardUtils.validateLocation(this.myState.get(WizardConstants.PROJECT_LOCATION_KEY));
        this.setErrorHtml(locationValidationResult.isOk() ? "" : locationValidationResult.getFormattedMessage());
        return this.validateAppName() && this.validatePackageName() && !locationValidationResult.isError();
    }

    private boolean validateAppName() {
        String appName = this.myState.get(WizardConstants.APPLICATION_NAME_KEY);
        if (appName == null || appName.isEmpty()) {
            this.setErrorHtml("Please enter an application name (shown in launcher)");
            return false;
        }
        if (Character.isLowerCase(appName.charAt(0))) {
            this.setErrorHtml("The application name for most apps begins with an uppercase letter");
        }
        return true;
    }

    private boolean validatePackageName() {
        String packageName = this.myState.get(WizardConstants.PACKAGE_NAME_KEY);
        if (packageName == null) {
            this.setErrorHtml("Please enter a package name (This package uniquely identifies your application)");
            return false;
        }
        String message = AndroidUtils.validateAndroidPackageName(packageName);
        if (message != null) {
            this.setErrorHtml("Invalid package name: " + message);
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        return "Create Android Project";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myAppName;
    }

    static String nameToPackage(String name) {
        name = name.replace('-', '_');
        if (!(name = name.replaceAll("[^a-zA-Z0-9_]", "")).isEmpty() && AndroidUtils.isReservedKeyword(name = name.toLowerCase(Locale.US)) != null) {
            name = (StringUtil.isVowel((char)name.charAt(0)) ? "an" : "a") + name;
        }
        return name;
    }

    @Override
    @NotNull
    protected DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings getStepHeader() {
        return ConfigureAndroidProjectPath.buildConfigurationHeader();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        LabelWithEditLink labelWithEditLink;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Application name:");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Company Domain:");
        jLabel2.setDisplayedMnemonic('C');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompanyDomain = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Package name:");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageName = labelWithEditLink = new LabelWithEditLink();
        jPanel.add((Component)labelWithEditLink, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Project location:");
        jPanel.add((Component)jLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIncludeCppCheck = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Include C++ Support");
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor(labelWithEditLink);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton);
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

