/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class GenerateVectorIconModel
extends GenerateIconsModel {
    public GenerateVectorIconModel(@NotNull AndroidFacet androidFacet) {
        super(androidFacet);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(GenerateVectorIconModel.class);
    }

    @Override
    protected void generateIntoPath(@NotNull AndroidProjectPaths paths, @NotNull AndroidIconGenerator iconGenerator) {
        VectorAsset vectorAsset = (VectorAsset)iconGenerator.sourceAsset().getValue();
        VectorAsset.ParseResult result = vectorAsset.parse();
        Map<File, BufferedImage> fileMap = iconGenerator.generateIntoFileMap(paths);
        ArrayList outputFiles = Lists.newArrayList(fileMap.keySet());
        assert (outputFiles.size() == 1);
        File file = (File)outputFiles.get(0);
        VirtualFile directory = null;
        try {
            directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile xmlFile = directory.findChild(file.getName());
            if (xmlFile == null || !xmlFile.exists()) {
                xmlFile = directory.createChildData((Object)this, file.getName());
            }
            VfsUtil.saveText((VirtualFile)xmlFile, (String)result.getXmlContent());
        }
        catch (IOException e) {
            GenerateVectorIconModel.getLog().error((Throwable)e);
        }
    }
}

