/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.IconPickerDialog;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VectorIconButton
extends JButton
implements AssetComponent<VectorAsset>,
Disposable {
    private final VectorAsset myXmlAsset = new VectorAsset(VectorAsset.FileType.VECTOR_DRAWABLE);
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myAssetListeners = Lists.newArrayListWithExpectedSize((int)1);
    @Nullable
    private VdIcon myIcon;

    public VectorIconButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IconPickerDialog iconPicker = new IconPickerDialog(VectorIconButton.this.myIcon);
                if (iconPicker.showAndGet()) {
                    VdIcon selectedIcon = iconPicker.getSelectedIcon();
                    assert (selectedIcon != null);
                    VectorIconButton.this.updateIcon(selectedIcon);
                }
            }
        });
        this.myXmlAsset.path().addListener(new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                ActionEvent e = new ActionEvent(VectorIconButton.this, 1001, null);
                for (ActionListener listener : VectorIconButton.this.myAssetListeners) {
                    listener.actionPerformed(e);
                }
            }
        });
        this.updateIcon(IconPickerDialog.getDefaultIcon());
    }

    private void updateIcon(@NotNull VdIcon selectedIcon) {
        this.myIcon = null;
        this.setIcon(null);
        try {
            File iconFile = new File(FileUtil.getTempDirectory(), selectedIcon.getName());
            InputStream iconStream = selectedIcon.getURL().openStream();
            FileOutputStream outputStream = new FileOutputStream(iconFile);
            FileUtil.copy((InputStream)iconStream, (OutputStream)outputStream);
            this.myXmlAsset.path().set(iconFile);
            int h = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
            VectorAsset.ParseResult result = this.myXmlAsset.parse(h);
            this.setIcon(new ImageIcon(result.getImage()));
            this.myIcon = selectedIcon;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public VectorAsset getAsset() {
        return this.myXmlAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener l) {
        this.myAssetListeners.add(l);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myAssetListeners.clear();
    }
}

