/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.google.common.collect.Lists;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ImageAssetBrowser
extends TextFieldWithBrowseButton
implements AssetComponent<ImageAsset> {
    private final ImageAsset myImageAsset = new ImageAsset();
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myListeners = Lists.newArrayListWithExpectedSize((int)1);

    public ImageAssetBrowser() {
        this.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        TextProperty imagePathText = new TextProperty(this.getTextField());
        this.myBindings.bind(imagePathText, this.myImageAsset.imagePath().transform(File::getAbsolutePath));
        this.myBindings.bind(this.myImageAsset.imagePath(), imagePathText.transform(File::new));
        InvalidationListener onImageChanged = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                ActionEvent e = new ActionEvent(ImageAssetBrowser.this, 1001, null);
                for (ActionListener listener : ImageAssetBrowser.this.myListeners) {
                    listener.actionPerformed(e);
                }
            }
        };
        this.myImageAsset.imagePath().addListener(onImageChanged);
    }

    @Override
    @NotNull
    public ImageAsset getAsset() {
        return this.myImageAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener l) {
        this.myListeners.add(l);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.clear();
    }
}

